/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractJQuerySelectorOptimizationCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;

@Rule(key="S2715")
public class IdChildrenSelectorCheck
extends AbstractJQuerySelectorOptimizationCheck {
    private static final String MESSAGE = "Move \"%s\" into \"find\" method.";
    private static final Pattern idChildrenSelectorPattern = Pattern.compile("(#[\\w_-]+)[ ]+([^ ]+)");

    @Override
    protected void visitSelector(String selector, CallExpressionTree tree) {
        Matcher matcher = idChildrenSelectorPattern.matcher(selector);
        if (matcher.matches()) {
            this.addIssue((Tree)tree, String.format(MESSAGE, matcher.group(2)));
        }
    }
}

