/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.KindSet;
import org.sonar.javascript.tree.SyntacticEquivalence;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="S4144")
public class IdenticalFunctionsCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Update this function so that its implementation is not identical to the one on line %s.";
    private final List<BlockTree> functionBlocks = new ArrayList<BlockTree>();

    public Set<Tree.Kind> nodesToVisit() {
        return KindSet.FUNCTION_KINDS.getSubKinds();
    }

    public void visitFile(Tree scriptTree) {
        this.functionBlocks.clear();
    }

    public void leaveFile(Tree scriptTree) {
        if (this.functionBlocks.size() < 2) {
            return;
        }
        block0: for (int i = 1; i < this.functionBlocks.size(); ++i) {
            BlockTree duplicatingFunctionBlock = this.functionBlocks.get(i);
            for (int j = 0; j < i; ++j) {
                BlockTree originalFunctionBlock = this.functionBlocks.get(j);
                if (!SyntacticEquivalence.areEquivalent((Tree)duplicatingFunctionBlock, (Tree)originalFunctionBlock)) continue;
                Tree originalFunctionIssueNode = IdenticalFunctionsCheck.functionTreeIssueNode((FunctionTree)originalFunctionBlock.parent());
                String message = String.format(MESSAGE, originalFunctionIssueNode.firstToken().line());
                Tree duplicatingFunctionIssueNode = IdenticalFunctionsCheck.functionTreeIssueNode((FunctionTree)duplicatingFunctionBlock.parent());
                this.addIssue(duplicatingFunctionIssueNode, message).secondary(originalFunctionIssueNode, "original implementation");
                continue block0;
            }
        }
    }

    private static Tree functionTreeIssueNode(FunctionTree functionTree) {
        if (functionTree.is(new Kinds[]{Tree.Kind.ARROW_FUNCTION})) {
            return ((ArrowFunctionTree)functionTree).doubleArrowToken();
        }
        if (functionTree.is(new Kinds[]{Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION})) {
            return ((FunctionExpressionTree)functionTree).functionKeyword();
        }
        return functionTree.name();
    }

    public void visitNode(Tree tree) {
        Tree body = ((FunctionTree)tree).body();
        if (body.is(new Kinds[]{Tree.Kind.BLOCK}) && IdenticalFunctionsCheck.isBigEnough((BlockTree)body)) {
            this.functionBlocks.add((BlockTree)body);
        }
    }

    private static boolean isBigEnough(BlockTree block) {
        List statements = block.statements();
        if (!statements.isEmpty()) {
            int firstLine = ((StatementTree)statements.get(0)).firstToken().line();
            int lastLine = ((StatementTree)statements.get(statements.size() - 1)).lastToken().endLine();
            return lastLine - firstLine > 1;
        }
        return false;
    }
}

