/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.ModuleTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.BracketMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.CaseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.DefaultClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S4143")
public class NoElementOverwriteCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Verify this is the index that was intended; '%s' was already set on line %s.";
    private static final List<Function<Tree, KeyWriteCollectionUsage>> GET_WRITE_USAGE_FUNCTIONS = ImmutableList.of(NoElementOverwriteCheck::arrayKeyWriteUsage, NoElementOverwriteCheck::mapOrSetWriteUsage, NoElementOverwriteCheck::objectKeyWriteUsage);

    public void visitBlock(BlockTree tree) {
        this.checkStatements(tree.statements());
        super.visitBlock(tree);
    }

    public void visitModule(ModuleTree tree) {
        this.checkStatements(tree.items());
        super.visitModule(tree);
    }

    public void visitCaseClause(CaseClauseTree tree) {
        this.checkStatements(tree.statements());
        super.visitCaseClause(tree);
    }

    public void visitDefaultClause(DefaultClauseTree tree) {
        this.checkStatements(tree.statements());
        super.visitDefaultClause(tree);
    }

    private <T extends Tree> void checkStatements(List<T> statements) {
        HashMap<String, KeyWriteCollectionUsage> usedKeys = new HashMap<String, KeyWriteCollectionUsage>();
        Symbol collection = null;
        for (Tree statement : statements) {
            KeyWriteCollectionUsage keyWriteUsage = NoElementOverwriteCheck.keyWriteUsage(statement);
            if (keyWriteUsage != null) {
                KeyWriteCollectionUsage sameKeyWriteUsage;
                if (collection != null && keyWriteUsage.collectionSymbol != collection) {
                    usedKeys.clear();
                }
                if ((sameKeyWriteUsage = (KeyWriteCollectionUsage)usedKeys.get(keyWriteUsage.indexOrKey)) != null) {
                    this.addIssue(keyWriteUsage.tree, NoElementOverwriteCheck.message(keyWriteUsage.indexOrKey, sameKeyWriteUsage.tree)).secondary(sameKeyWriteUsage.tree);
                }
                usedKeys.put(keyWriteUsage.indexOrKey, keyWriteUsage);
                collection = keyWriteUsage.collectionSymbol;
                continue;
            }
            usedKeys.clear();
        }
    }

    @Nullable
    private static KeyWriteCollectionUsage keyWriteUsage(Tree tree) {
        if (tree.is(new Kinds[]{Tree.Kind.EXPRESSION_STATEMENT})) {
            ExpressionTree expression = ((ExpressionStatementTree)tree).expression();
            for (Function<Tree, KeyWriteCollectionUsage> getWriteUsageFunction : GET_WRITE_USAGE_FUNCTIONS) {
                KeyWriteCollectionUsage writeUsage = getWriteUsageFunction.apply((Tree)expression);
                if (writeUsage == null) continue;
                return writeUsage;
            }
        }
        return null;
    }

    @Nullable
    private static KeyWriteCollectionUsage arrayKeyWriteUsage(Tree tree) {
        BracketMemberExpressionTree memberExpression;
        if (!tree.is(new Kinds[]{Tree.Kind.ASSIGNMENT})) {
            return null;
        }
        AssignmentExpressionTree assignmentExpression = (AssignmentExpressionTree)tree;
        if (assignmentExpression.variable().is(new Kinds[]{Tree.Kind.BRACKET_MEMBER_EXPRESSION}) && (memberExpression = (BracketMemberExpressionTree)assignmentExpression.variable()).object().is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
            Optional symbol = ((IdentifierTree)memberExpression.object()).symbol();
            String index = NoElementOverwriteCheck.extractIndex((List<ExpressionTree>)ImmutableList.of((Object)memberExpression.property()));
            if (symbol.isPresent() && index != null && !NoElementOverwriteCheck.usedInRhs(assignmentExpression.expression(), (Symbol)symbol.get())) {
                return new KeyWriteCollectionUsage((Symbol)symbol.get(), index, (Tree)memberExpression.object());
            }
        }
        return null;
    }

    private static boolean usedInRhs(ExpressionTree rhs, Symbol symbol) {
        IdentifierVisitor identifierVisitor = new IdentifierVisitor(symbol);
        rhs.accept((DoubleDispatchVisitor)identifierVisitor);
        return identifierVisitor.usageFound;
    }

    private static String message(String index, Tree previousUsage) {
        int line = previousUsage.firstToken().line();
        return String.format(MESSAGE, index, line);
    }

    @Nullable
    private static KeyWriteCollectionUsage mapOrSetWriteUsage(Tree tree) {
        DotMemberExpressionTree callee;
        if (!tree.is(new Kinds[]{Tree.Kind.CALL_EXPRESSION})) {
            return null;
        }
        CallExpressionTree callExpression = (CallExpressionTree)tree;
        int argumentsNumber = callExpression.argumentClause().arguments().size();
        if (callExpression.callee().is(new Kinds[]{Tree.Kind.DOT_MEMBER_EXPRESSION}) && (callee = (DotMemberExpressionTree)callExpression.callee()).object().is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
            boolean setMethod;
            Optional symbol = ((IdentifierTree)callee.object()).symbol();
            String methodName = callee.property().name();
            String index = NoElementOverwriteCheck.extractIndex((List<ExpressionTree>)callExpression.argumentClause().arguments());
            boolean addMethod = methodName.equals("add") && argumentsNumber == 1;
            boolean bl = setMethod = methodName.equals("set") && argumentsNumber == 2;
            if (symbol.isPresent() && (addMethod || setMethod) && index != null) {
                return new KeyWriteCollectionUsage((Symbol)symbol.get(), index, (Tree)callee.object());
            }
        }
        return null;
    }

    @Nullable
    private static String extractIndex(List<ExpressionTree> arguments) {
        if (arguments.isEmpty()) {
            return null;
        }
        ExpressionTree firstArgument = arguments.get(0);
        if (firstArgument.is(new Kinds[]{Tree.Kind.NUMERIC_LITERAL, Tree.Kind.STRING_LITERAL})) {
            String value = ((LiteralTree)firstArgument).value();
            return firstArgument.is(new Kinds[]{Tree.Kind.STRING_LITERAL}) ? value.substring(1, value.length() - 1) : value;
        }
        if (firstArgument.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
            return ((IdentifierTree)firstArgument).name();
        }
        return null;
    }

    @Nullable
    private static KeyWriteCollectionUsage objectKeyWriteUsage(Tree tree) {
        if (!tree.is(new Kinds[]{Tree.Kind.ASSIGNMENT})) {
            return null;
        }
        AssignmentExpressionTree assignmentExpression = (AssignmentExpressionTree)tree;
        if (assignmentExpression.variable().is(new Kinds[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
            DotMemberExpressionTree lhs = (DotMemberExpressionTree)assignmentExpression.variable();
            if (!lhs.object().is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
                return null;
            }
            Optional symbol = ((IdentifierTree)lhs.object()).symbol();
            if (!symbol.isPresent()) {
                return null;
            }
            if (NoElementOverwriteCheck.usedInRhs(assignmentExpression.expression(), (Symbol)symbol.get())) {
                return null;
            }
            String property = lhs.property().name();
            return new KeyWriteCollectionUsage((Symbol)symbol.get(), property, (Tree)lhs.object());
        }
        return null;
    }

    private static class KeyWriteCollectionUsage {
        Symbol collectionSymbol;
        String indexOrKey;
        Tree tree;

        KeyWriteCollectionUsage(Symbol collectionSymbol, String indexOrKey, Tree tree) {
            this.collectionSymbol = collectionSymbol;
            this.indexOrKey = indexOrKey;
            this.tree = tree;
        }
    }

    private static class IdentifierVisitor
    extends DoubleDispatchVisitor {
        final Symbol symbolToFind;
        boolean usageFound = false;

        IdentifierVisitor(Symbol symbolToFind) {
            this.symbolToFind = symbolToFind;
        }

        public void visitIdentifier(IdentifierTree tree) {
            Optional symbol = tree.symbol();
            if (symbol.isPresent() && symbol.get() == this.symbolToFind) {
                this.usageFound = true;
            }
        }
    }
}

