/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S1301")
public class SwitchWithNotEnoughCaseCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Replace this \"switch\" statement with \"if\" statements to increase readability.";

    public void visitSwitchStatement(SwitchStatementTree tree) {
        boolean hasDefault = false;
        for (SwitchClauseTree switchClauseTree : tree.cases()) {
            if (!switchClauseTree.is(new Kinds[]{Tree.Kind.DEFAULT_CLAUSE})) continue;
            hasDefault = true;
        }
        if (tree.cases().size() < 2 || tree.cases().size() == 2 && hasDefault) {
            this.addIssue((Tree)tree.switchKeyword(), MESSAGE);
        }
        super.visitSwitchStatement(tree);
    }
}

