/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S1125")
public class BooleanEqualityComparisonCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE_REFACTOR = "Refactor the code to avoid using this boolean literal.";
    private static final String MESSAGE_SIMPLIFY = "Simplify this unnecessary boolean operation.";

    public void visitUnaryExpression(UnaryExpressionTree tree) {
        if (tree.is(new Kinds[]{Tree.Kind.LOGICAL_COMPLEMENT})) {
            this.visitExpression(tree.expression(), MESSAGE_SIMPLIFY);
        }
        super.visitUnaryExpression(tree);
    }

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (tree.is(new Kinds[]{Tree.Kind.EQUAL_TO, Tree.Kind.NOT_EQUAL_TO})) {
            this.visitExpression(tree.leftOperand(), MESSAGE_REFACTOR);
            this.visitExpression(tree.rightOperand(), MESSAGE_REFACTOR);
        }
        super.visitBinaryExpression(tree);
    }

    private void visitExpression(ExpressionTree expression, String message) {
        if (expression.is(new Kinds[]{Tree.Kind.PARENTHESISED_EXPRESSION})) {
            this.visitExpression(((ParenthesisedExpressionTree)expression).expression(), message);
        }
        if (expression.is(new Kinds[]{Tree.Kind.BOOLEAN_LITERAL})) {
            this.addIssue((Tree)expression, message);
        }
    }
}

