/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S3981")
public class CollectionSizeComparisonCheck
extends DoubleDispatchVisitorCheck {
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        DotMemberExpressionTree leftOperand;
        if (tree.is(new Kinds[]{Tree.Kind.LESS_THAN, Tree.Kind.GREATER_THAN_OR_EQUAL_TO}) && CollectionSizeComparisonCheck.isZeroLiteral(tree.rightOperand()) && tree.leftOperand().is(new Kinds[]{Tree.Kind.DOT_MEMBER_EXPRESSION}) && CollectionSizeComparisonCheck.isLengthOrSizeProperty(leftOperand = (DotMemberExpressionTree)tree.leftOperand())) {
            String propertyName = leftOperand.property().name();
            this.addIssue((Tree)tree, String.format("Fix this expression; %s of \"%s\" is always greater or equal to zero.", propertyName, CheckUtils.asString((Tree)leftOperand.object())));
        }
        super.visitBinaryExpression(tree);
    }

    private static boolean isLengthOrSizeProperty(DotMemberExpressionTree memberExpressionTree) {
        String name = memberExpressionTree.property().name();
        return "length".equals(name) || "size".equals(name);
    }

    private static boolean isZeroLiteral(ExpressionTree tree) {
        return tree.is(new Kinds[]{Tree.Kind.NUMERIC_LITERAL}) && ((LiteralTree)tree).value().equals("0");
    }
}

