/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.apache.commons.lang.StringUtils;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.LineIssue;

public class CommentContainsPatternChecker {
    private final JavaScriptCheck check;
    private final String pattern;
    private final String message;

    public CommentContainsPatternChecker(JavaScriptCheck check, String pattern, String message) {
        this.check = check;
        this.pattern = pattern;
        this.message = message;
    }

    public void visitToken(SyntaxToken token) {
        for (SyntaxTrivia trivia : token.trivias()) {
            String comment = trivia.text();
            if (!StringUtils.containsIgnoreCase((String)comment, (String)this.pattern)) continue;
            String[] lines = comment.split("\r\n?|\n");
            for (int i = 0; i < lines.length; ++i) {
                if (!StringUtils.containsIgnoreCase((String)lines[i], (String)this.pattern) || CommentContainsPatternChecker.isLetterAround(lines[i], this.pattern)) continue;
                this.check.addIssue((Issue)new LineIssue(this.check, trivia.line() + i, this.message));
            }
        }
    }

    private static boolean isLetterAround(String line, String pattern) {
        int start = StringUtils.indexOfIgnoreCase((String)line, (String)pattern);
        int end = start + pattern.length();
        boolean pre = start > 0 ? Character.isLetter(line.charAt(start - 1)) : false;
        boolean post = end < line.length() - 1 ? Character.isLetter(line.charAt(end)) : false;
        return pre || post;
    }
}

