/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.SeparatedList;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ThrowStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.VariableDeclarationTree;
import org.sonar.plugins.javascript.api.tree.statement.VariableStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S1488")
public class ImmediatelyReturnedVariableCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Immediately %s this expression instead of assigning it to the temporary variable \"%s\".";

    public void visitBlock(BlockTree tree) {
        List statements = tree.statements();
        if (statements.size() > 1) {
            StatementTree lastButOneStatement = (StatementTree)statements.get(statements.size() - 2);
            StatementTree lastStatement = (StatementTree)statements.get(statements.size() - 1);
            if (lastButOneStatement.is(new Kinds[]{Tree.Kind.VARIABLE_STATEMENT})) {
                this.checkStatements(((VariableStatementTree)lastButOneStatement).declaration(), lastStatement);
            }
        }
        super.visitBlock(tree);
    }

    private void checkStatements(VariableDeclarationTree variableDeclaration, StatementTree lastStatement) {
        InitializedBindingElementTree initializedBindingElementTree;
        SeparatedList variables = variableDeclaration.variables();
        if (variables.size() == 1 && ((BindingElementTree)variables.get(0)).is(new Kinds[]{Tree.Kind.INITIALIZED_BINDING_ELEMENT}) && (initializedBindingElementTree = (InitializedBindingElementTree)variables.get(0)).left().is(new Kinds[]{Tree.Kind.BINDING_IDENTIFIER})) {
            IdentifierTree identifier = (IdentifierTree)initializedBindingElementTree.left();
            if (ImmediatelyReturnedVariableCheck.hasUsageInsideExpression((Symbol)identifier.symbol().get(), initializedBindingElementTree.right())) {
                return;
            }
            String name = identifier.name();
            if (ImmediatelyReturnedVariableCheck.returnsVariableInLastStatement(lastStatement, name)) {
                this.addIssue((Tree)initializedBindingElementTree.right(), String.format(MESSAGE, "return", name));
            } else if (ImmediatelyReturnedVariableCheck.throwsVariableInLastStatement(lastStatement, name)) {
                this.addIssue((Tree)initializedBindingElementTree.right(), String.format(MESSAGE, "throw", name));
            }
        }
    }

    private static boolean hasUsageInsideExpression(Symbol symbol, ExpressionTree expression) {
        for (Usage usage : symbol.usages()) {
            if (!expression.isAncestorOf((Tree)usage.identifierTree())) continue;
            return true;
        }
        return false;
    }

    private static boolean returnsVariableInLastStatement(StatementTree lastStatement, String variableName) {
        if (lastStatement.is(new Kinds[]{Tree.Kind.RETURN_STATEMENT})) {
            ReturnStatementTree returnStatement = (ReturnStatementTree)lastStatement;
            return ImmediatelyReturnedVariableCheck.isVariable(returnStatement.expression(), variableName);
        }
        return false;
    }

    private static boolean throwsVariableInLastStatement(StatementTree lastStatement, String variableName) {
        if (lastStatement.is(new Kinds[]{Tree.Kind.THROW_STATEMENT})) {
            ThrowStatementTree throwStatement = (ThrowStatementTree)lastStatement;
            return ImmediatelyReturnedVariableCheck.isVariable(throwStatement.expression(), variableName);
        }
        return false;
    }

    private static boolean isVariable(@Nullable ExpressionTree expressionTree, String variableName) {
        if (expressionTree != null && expressionTree.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
            String thrownName = ((IdentifierTree)expressionTree).name();
            return thrownName.equals(variableName);
        }
        return false;
    }
}

