/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="S2692")
public class IndexOfCompareToPositiveNumberCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "This check ignores index 0; consider using 'includes' method to make this check safe and explicit.";

    public Set<Tree.Kind> nodesToVisit() {
        return ImmutableSet.of((Object)Tree.Kind.GREATER_THAN);
    }

    public void visitNode(Tree tree) {
        BinaryExpressionTree expression = (BinaryExpressionTree)tree;
        if (IndexOfCompareToPositiveNumberCheck.isZero(expression.rightOperand()) && IndexOfCompareToPositiveNumberCheck.isIndexOfCall(expression.leftOperand())) {
            this.addIssue(tree, MESSAGE);
        }
    }

    private static boolean isIndexOfCall(ExpressionTree expression) {
        CallExpressionTree callExpr;
        if (expression.is(new Kinds[]{Tree.Kind.CALL_EXPRESSION}) && (callExpr = (CallExpressionTree)expression).argumentClause().arguments().size() == 1 && callExpr.callee().is(new Kinds[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
            DotMemberExpressionTree memberExpr = (DotMemberExpressionTree)((CallExpressionTree)expression).callee();
            return "indexOf".equals(memberExpr.property().name());
        }
        return false;
    }

    private static boolean isZero(ExpressionTree expression) {
        return expression.is(new Kinds[]{Tree.Kind.NUMERIC_LITERAL}) && "0".equals(((LiteralTree)expression).value());
    }
}

