/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.javascript.tree.KindSet;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ConditionalExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S3358")
public class NestedConditionalOperatorsCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Extract this nested ternary operation into an independent statement.";
    private int nestingLevel;

    public void visitScript(ScriptTree tree) {
        this.nestingLevel = 0;
        super.visitScript(tree);
    }

    public void visitConditionalExpression(ConditionalExpressionTree conditionalExpression) {
        if (this.nestingLevel > 0 && !NestedConditionalOperatorsCheck.isNestingBroken(conditionalExpression)) {
            this.addIssue((Tree)conditionalExpression, MESSAGE);
        }
        ++this.nestingLevel;
        super.visitConditionalExpression(conditionalExpression);
        --this.nestingLevel;
    }

    private static boolean isNestingBroken(ConditionalExpressionTree conditionalExpression) {
        Tree parent = conditionalExpression.parent();
        while (!parent.is(new Kinds[]{Tree.Kind.CONDITIONAL_EXPRESSION})) {
            if (NestedConditionalOperatorsCheck.breaksNesting(parent)) {
                return true;
            }
            parent = parent.parent();
        }
        return false;
    }

    private static boolean breaksNesting(Tree tree) {
        return tree.is(new Kinds[]{Tree.Kind.ARRAY_LITERAL, Tree.Kind.OBJECT_LITERAL}) || tree.is(new Kinds[]{KindSet.FUNCTION_KINDS});
    }
}

