/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.tree.KindSet;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S905")
public class UselessExpressionStatementCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Refactor or remove this statement.";
    private static final Set<String> KNOWN_DIRECTIVES = ImmutableSet.of((Object)"use strict", (Object)"$:nomunge", (Object)"ngInject");
    private static final Kinds[] KINDS_WITH_SIDE_EFFECTS = new Kinds[]{KindSet.ASSIGNMENT_KINDS, Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR, Tree.Kind.CONDITIONAL_EXPRESSION, Tree.Kind.CALL_EXPRESSION, Tree.Kind.NEW_EXPRESSION, KindSet.INC_DEC_KINDS, Tree.Kind.YIELD_EXPRESSION, Tree.Kind.DELETE, Tree.Kind.COMMA_OPERATOR, Tree.Kind.BRACKET_MEMBER_EXPRESSION, Tree.Kind.DOT_MEMBER_EXPRESSION, Tree.Kind.VOID, Tree.Kind.AWAIT, Tree.Kind.TAGGED_TEMPLATE};

    public void visitExpressionStatement(ExpressionStatementTree tree) {
        ExpressionTree expression = CheckUtils.removeParenthesis(tree.expression());
        if (expression.is(new Kinds[]{Tree.Kind.STRING_LITERAL})) {
            if (!UselessExpressionStatementCheck.isDirective((LiteralTree)expression)) {
                this.addIssue((Tree)tree, MESSAGE);
            }
        } else if (!(expression.is(KINDS_WITH_SIDE_EFFECTS) || UselessExpressionStatementCheck.isIIFE(expression) || UselessExpressionStatementCheck.insideTry(tree))) {
            this.addIssue((Tree)tree, MESSAGE);
        }
        super.visitExpressionStatement(tree);
    }

    private static boolean insideTry(ExpressionStatementTree tree) {
        return tree.parent().parent().is(new Kinds[]{Tree.Kind.TRY_STATEMENT});
    }

    private static boolean isIIFE(ExpressionTree expression) {
        if (expression.is(new Kinds[]{Tree.Kind.CALL_EXPRESSION})) {
            CallExpressionTree callExpressionTree = (CallExpressionTree)expression;
            ExpressionTree callee = CheckUtils.removeParenthesis(callExpressionTree.callee());
            return callee.is(new Kinds[]{Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.ARROW_FUNCTION});
        }
        if (expression.is(new Kinds[]{Tree.Kind.LOGICAL_COMPLEMENT})) {
            ExpressionTree operand = ((UnaryExpressionTree)expression).expression();
            return UselessExpressionStatementCheck.isIIFE(CheckUtils.removeParenthesis(operand));
        }
        return false;
    }

    private static boolean isDirective(LiteralTree tree) {
        if (tree.is(new Kinds[]{Tree.Kind.STRING_LITERAL})) {
            return KNOWN_DIRECTIVES.contains(UselessExpressionStatementCheck.trimQuotes(tree.value()));
        }
        return false;
    }

    private static String trimQuotes(String value) {
        return value.substring(1, value.length() - 1);
    }
}

