/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S2703")
public class VariableDeclarationWithoutVarCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Add the \"let\", \"const\" or \"var\" keyword to this declaration of \"%s\" to make it explicit.";
    private static final Set<String> EXCLUDED_NAMES = ImmutableSet.of((Object)"exports", (Object)"module");

    public void visitScript(ScriptTree tree) {
        for (Symbol symbol : this.getContext().getSymbolModel().getSymbols()) {
            if (!symbol.isVariable() || symbol.external() || EXCLUDED_NAMES.contains(symbol.name())) continue;
            this.visitSymbol(symbol);
        }
    }

    private void visitSymbol(Symbol symbol) {
        for (Usage usage : symbol.usages()) {
            if (!usage.isDeclaration()) continue;
            return;
        }
        if (!symbol.usages().isEmpty()) {
            this.addIssue((Tree)((Usage)symbol.usages().iterator().next()).identifierTree(), String.format(MESSAGE, symbol.name()));
        }
    }
}

