/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.javascript.tree.SyntacticEquivalence;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.IfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

public abstract class AbstractDuplicateBranchImplementationCheck
extends DoubleDispatchVisitorCheck {
    private Set<IfStatementTree> chainedIfStatements = new HashSet<IfStatementTree>();

    public void visitScript(ScriptTree tree) {
        this.chainedIfStatements.clear();
        super.visitScript(tree);
    }

    public void visitIfStatement(IfStatementTree tree) {
        if (!this.chainedIfStatements.contains(tree)) {
            List<Tree> branches = this.collectBranches(tree);
            if (AbstractDuplicateBranchImplementationCheck.allBranchesPresent(tree) && AbstractDuplicateBranchImplementationCheck.allBranchesEquivalent(branches)) {
                this.allBranchesDuplicated((Tree)tree);
            } else {
                this.checkDuplicatedBranches(branches);
            }
        }
        super.visitIfStatement(tree);
    }

    public void visitSwitchStatement(SwitchStatementTree tree) {
        boolean hasFallthrough = false;
        boolean hasDefaultCase = false;
        ArrayList<Tree> branches = new ArrayList<Tree>();
        for (int i = 0; i < tree.cases().size(); ++i) {
            boolean isLast;
            SwitchClauseTree caseTree = (SwitchClauseTree)tree.cases().get(i);
            boolean bl = isLast = i == tree.cases().size() - 1;
            if (caseTree.is(new Kinds[]{Tree.Kind.DEFAULT_CLAUSE})) {
                hasDefaultCase = true;
            }
            if (!caseTree.statements().isEmpty() || isLast) {
                branches.add((Tree)caseTree);
            }
            if (AbstractDuplicateBranchImplementationCheck.endsWithJump(caseTree) || isLast) continue;
            hasFallthrough = true;
        }
        if (!hasFallthrough && hasDefaultCase && AbstractDuplicateBranchImplementationCheck.allBranchesEquivalent(branches)) {
            this.allBranchesDuplicated((Tree)tree);
        } else {
            this.checkDuplicatedBranches(branches);
        }
        super.visitSwitchStatement(tree);
    }

    protected abstract void checkDuplicatedBranches(List<Tree> var1);

    protected abstract void allBranchesDuplicated(Tree var1);

    private static boolean allBranchesEquivalent(List<Tree> branches) {
        Tree firstBranch = branches.get(0);
        for (int i = 1; i < branches.size(); ++i) {
            if (AbstractDuplicateBranchImplementationCheck.syntacticallyEqual(firstBranch, branches.get(i))) continue;
            return false;
        }
        return true;
    }

    private List<Tree> collectBranches(IfStatementTree ifStatement) {
        ArrayList<Tree> branches = new ArrayList<Tree>();
        branches.add((Tree)ifStatement.statement());
        ElseClauseTree elseClause = ifStatement.elseClause();
        while (elseClause != null) {
            if (elseClause.statement().is(new Kinds[]{Tree.Kind.IF_STATEMENT})) {
                IfStatementTree chainedIfStatement = (IfStatementTree)elseClause.statement();
                this.chainedIfStatements.add(chainedIfStatement);
                branches.add((Tree)chainedIfStatement.statement());
                elseClause = chainedIfStatement.elseClause();
                continue;
            }
            branches.add((Tree)elseClause.statement());
            elseClause = null;
        }
        return branches;
    }

    private static boolean allBranchesPresent(IfStatementTree tree) {
        StatementTree elseStatement;
        IfStatementTree lastIfStatement = tree;
        while (lastIfStatement.elseClause() != null && (elseStatement = lastIfStatement.elseClause().statement()).is(new Kinds[]{Tree.Kind.IF_STATEMENT})) {
            lastIfStatement = (IfStatementTree)elseStatement;
        }
        return lastIfStatement.elseClause() != null;
    }

    private static boolean endsWithJump(SwitchClauseTree caseTree) {
        return !caseTree.statements().isEmpty() && ((StatementTree)Iterables.getLast((Iterable)caseTree.statements())).is(new Kinds[]{Tree.Kind.BREAK_STATEMENT, Tree.Kind.RETURN_STATEMENT, Tree.Kind.CONTINUE_STATEMENT, Tree.Kind.THROW_STATEMENT});
    }

    static List<StatementTree> normalize(SwitchClauseTree switchClause) {
        List list = switchClause.statements();
        if (!list.isEmpty() && ((StatementTree)list.get(list.size() - 1)).is(new Kinds[]{Tree.Kind.BREAK_STATEMENT})) {
            return list.subList(0, list.size() - 1);
        }
        return list;
    }

    static boolean syntacticallyEqual(Tree first, Tree second) {
        if (first instanceof SwitchClauseTree) {
            return SyntacticEquivalence.areEquivalent(AbstractDuplicateBranchImplementationCheck.normalize((SwitchClauseTree)first), AbstractDuplicateBranchImplementationCheck.normalize((SwitchClauseTree)second));
        }
        return SyntacticEquivalence.areEquivalent((Tree)first, (Tree)second);
    }
}

