/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S1442")
public class AlertUseCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove this usage of %s(...).";
    private static final Set<String> OPEN_DIALOG_METHODS = ImmutableSet.of((Object)"alert", (Object)"prompt", (Object)"confirm");

    public void visitCallExpression(CallExpressionTree tree) {
        ExpressionTree callee = tree.callee();
        if (callee.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE}) && OPEN_DIALOG_METHODS.contains(((IdentifierTree)callee).name())) {
            this.addIssue((Tree)tree, String.format(MESSAGE, ((IdentifierTree)callee).name()));
        }
        super.visitCallExpression(tree);
    }
}

