/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.ForObjectStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.IfStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S3973")
public class ConditionalIndentationCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Use curly braces or indentation to denote the code conditionally executed by this \"%s\".";

    public void visitIfStatement(IfStatementTree tree) {
        if (!tree.parent().is(new Kinds[]{Tree.Kind.ELSE_CLAUSE})) {
            this.checkIndentation(tree.ifKeyword(), tree.statement());
        }
        super.visitIfStatement(tree);
    }

    public void visitWhileStatement(WhileStatementTree tree) {
        this.checkIndentation(tree.whileKeyword(), tree.statement());
        super.visitWhileStatement(tree);
    }

    public void visitElseClause(ElseClauseTree tree) {
        if (tree.statement().is(new Kinds[]{Tree.Kind.IF_STATEMENT})) {
            this.checkIndentation(tree.elseKeyword(), ((IfStatementTree)tree.statement()).statement());
        } else {
            this.checkIndentation(tree.elseKeyword(), tree.statement());
        }
        super.visitElseClause(tree);
    }

    public void visitForObjectStatement(ForObjectStatementTree tree) {
        this.checkIndentation(tree.forKeyword(), tree.statement());
        super.visitForObjectStatement(tree);
    }

    public void visitForStatement(ForStatementTree tree) {
        this.checkIndentation(tree.forKeyword(), tree.statement());
        super.visitForStatement(tree);
    }

    private void checkIndentation(SyntaxToken conditionalFirstToken, StatementTree statement) {
        if (statement.is(new Kinds[]{Tree.Kind.BLOCK})) {
            return;
        }
        SyntaxToken firstStatementToken = statement.firstToken();
        if (conditionalFirstToken.column() >= firstStatementToken.column()) {
            String message = String.format(MESSAGE, conditionalFirstToken.text());
            this.addIssue((Tree)conditionalFirstToken, message).secondary((Tree)firstStatementToken);
        }
    }
}

