/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="OctalNumber")
public class OctalNumberCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Replace the value of the octal number (%s) by its decimal equivalent (%s).";

    public void visitLiteral(LiteralTree tree) {
        String value;
        if (tree.is(new Kinds[]{Tree.Kind.NUMERIC_LITERAL}) && (value = tree.value()).length() > 1 && value.startsWith("0")) {
            int newValue;
            try {
                newValue = Integer.parseInt(value, 8);
            }
            catch (NumberFormatException e) {
                return;
            }
            if (newValue > 9) {
                this.addIssue((Tree)tree, String.format(MESSAGE, value, newValue));
            }
        }
    }
}

