/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.jsx.JsxStandardAttributeTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="SingleQuote")
public class SingleQuoteStringLiteralsCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Replace double quotes by single quotes";

    public void visitJsxStandardAttribute(JsxStandardAttributeTree tree) {
        if (!tree.value().is(new Kinds[]{Tree.Kind.STRING_LITERAL})) {
            this.scan((Tree)tree.value());
        }
    }

    public void visitLiteral(LiteralTree tree) {
        String value = tree.value();
        if (tree.is(new Kinds[]{Tree.Kind.STRING_LITERAL}) && value.startsWith("\"") && value.indexOf(39) < 0) {
            this.addIssue((Tree)tree, MESSAGE);
        }
    }
}

