/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.cfg.CfgBlock;
import org.sonar.javascript.cfg.ControlFlowGraph;
import org.sonar.javascript.checks.AbstractAnyPathSeCheck;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.builtins.BuiltInObjectSymbolicValue;
import org.sonar.javascript.se.points.ProgramPoint;
import org.sonar.javascript.se.sv.FunctionWithTreeSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.ArrowFunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.FunctionExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;

@Rule(key="S3796")
public class ArrayCallbackWithoutReturnCheck
extends AbstractAnyPathSeCheck {
    private static final String MESSAGE = "Add a \"return\" statement to this callback.";
    private static final Set<String> METHODS_WITH_CALLBACK = ImmutableSet.of((Object)"every", (Object)"filter", (Object)"find", (Object)"findIndex", (Object)"map", (Object)"reduce", (Object[])new String[]{"reduceRight", "some", "sort"});

    public void beforeBlockElement(ProgramState currentState, Tree element, ProgramPoint programPoint) {
        if (element.is(new Kinds[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
            DotMemberExpressionTree memberExpression = (DotMemberExpressionTree)element;
            if (ArrayCallbackWithoutReturnCheck.isArrayPropertyExecuted(currentState) && METHODS_WITH_CALLBACK.contains(memberExpression.property().name())) {
                this.checkArgumentToBeFunctionWithReturn(memberExpression, 0, currentState);
            } else if (ArrayCallbackWithoutReturnCheck.isArrayFromMethod(memberExpression, currentState)) {
                this.checkArgumentToBeFunctionWithReturn(memberExpression, 1, currentState);
            }
        }
    }

    private void checkArgumentToBeFunctionWithReturn(DotMemberExpressionTree callee, int argumentIndex, ProgramState currentState) {
        CallExpressionTree callExpressionTree;
        Tree parent = callee.parent();
        if (parent.is(new Kinds[]{Tree.Kind.CALL_EXPRESSION}) && (callExpressionTree = (CallExpressionTree)parent).argumentClause().arguments().size() > argumentIndex) {
            Tree argument = (Tree)callExpressionTree.argumentClause().arguments().get(argumentIndex);
            if (argument.is(new Kinds[]{Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.ARROW_FUNCTION}) && !ArrayCallbackWithoutReturnCheck.hasReturnWithValue((FunctionTree)argument) && !ArrayCallbackWithoutReturnCheck.isAsyncFunction((FunctionTree)argument)) {
                this.addUniqueIssue((Tree)ArrayCallbackWithoutReturnCheck.functionToken((FunctionTree)argument), MESSAGE);
            } else if (argument.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
                this.checkArgumentIdentifier((IdentifierTree)argument, currentState);
            }
        }
    }

    private void checkArgumentIdentifier(IdentifierTree argument, ProgramState currentState) {
        FunctionTree functionTree;
        SymbolicValue symbolicValue;
        Optional symbol = argument.symbol();
        if (symbol.isPresent() && (symbolicValue = currentState.getSymbolicValue((Symbol)symbol.get())) instanceof FunctionWithTreeSymbolicValue && !ArrayCallbackWithoutReturnCheck.hasReturnWithValue(functionTree = ((FunctionWithTreeSymbolicValue)symbolicValue).getFunctionTree()) && !ArrayCallbackWithoutReturnCheck.isAsyncFunction(functionTree)) {
            IssueLocation secondaryLocation = new IssueLocation((Tree)ArrayCallbackWithoutReturnCheck.functionToken(functionTree), "Callback declaration");
            this.addUniqueIssue((Tree)argument, MESSAGE, secondaryLocation);
        }
    }

    private static boolean isAsyncFunction(FunctionTree functionTree) {
        return functionTree.asyncToken() != null;
    }

    private static SyntaxToken functionToken(FunctionTree functionTree) {
        SyntaxToken token = functionTree.is(new Kinds[]{Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.GENERATOR_DECLARATION}) ? ((FunctionDeclarationTree)functionTree).name().identifierToken() : (functionTree.is(new Kinds[]{Tree.Kind.FUNCTION_EXPRESSION, Tree.Kind.GENERATOR_FUNCTION_EXPRESSION}) ? ((FunctionExpressionTree)functionTree).functionKeyword() : ((ArrowFunctionTree)functionTree).doubleArrowToken());
        return token;
    }

    private static boolean hasReturnWithValue(FunctionTree functionTree) {
        if (functionTree.body().is(new Kinds[]{Tree.Kind.BLOCK})) {
            ControlFlowGraph cfg = ControlFlowGraph.build((BlockTree)((BlockTree)functionTree.body()));
            for (CfgBlock cfgBlock : cfg.blocks()) {
                if (cfgBlock.elements().isEmpty()) continue;
                Tree lastElement = (Tree)cfgBlock.elements().get(cfgBlock.elements().size() - 1);
                if (!lastElement.is(new Kinds[]{Tree.Kind.RETURN_STATEMENT}) || ((ReturnStatementTree)lastElement).expression() == null) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static boolean isArrayPropertyExecuted(ProgramState currentState) {
        SymbolicValue symbolicValue = currentState.peekStack();
        Constraint constraint = currentState.getConstraint(symbolicValue);
        return constraint.isStricterOrEqualTo(Constraint.ARRAY);
    }

    private static boolean isArrayFromMethod(DotMemberExpressionTree memberExpression, ProgramState currentState) {
        SymbolicValue symbolicValue = currentState.peekStack();
        return symbolicValue.equals(BuiltInObjectSymbolicValue.ARRAY) && "from".equals(memberExpression.property().name());
    }
}

