/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S2427")
public class ParseIntCallWithoutBaseCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Add the base to this \"parseInt\" call.";

    public void visitCallExpression(CallExpressionTree tree) {
        if (ParseIntCallWithoutBaseCheck.isParseIntCall(tree.callee()) && tree.argumentClause().arguments().size() == 1) {
            this.addIssue((Tree)tree.callee(), MESSAGE);
        }
        super.visitCallExpression(tree);
    }

    private static boolean isParseIntCall(ExpressionTree callee) {
        return callee.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE}) && "parseInt".equals(((IdentifierTree)callee).name());
    }
}

