/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.tree.SyntacticEquivalence;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S1656")
public class SelfAssignmentCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove or correct this useless self-assignment.";
    private static final Set<String> METHODS_WITH_SIDE_EFFECTS = new HashSet<String>(Arrays.asList("sort", "reverse"));

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        ExpressionTree variable = tree.variable();
        if (tree.is(new Kinds[]{Tree.Kind.ASSIGNMENT}) && variable.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE}) && SelfAssignmentCheck.sameValue((IdentifierTree)variable, tree.expression())) {
            this.addIssue((Tree)tree, MESSAGE);
        }
        super.visitAssignmentExpression(tree);
    }

    private static boolean sameValue(IdentifierTree variable, ExpressionTree expression) {
        if (SyntacticEquivalence.areEquivalent((Tree)variable, (Tree)expression)) {
            return true;
        }
        if (expression.is(new Kinds[]{Tree.Kind.CALL_EXPRESSION}) && ((CallExpressionTree)expression).callee().is(new Kinds[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
            DotMemberExpressionTree callee = (DotMemberExpressionTree)((CallExpressionTree)expression).callee();
            String method = callee.property().name();
            return SelfAssignmentCheck.sameValue(variable, callee.object()) && METHODS_WITH_SIDE_EFFECTS.contains(method);
        }
        return false;
    }
}

