/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.metrics.FunctionDefiningModuleVisitor;
import org.sonar.javascript.tree.KindSet;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="S138")
public class TooManyLinesInFunctionCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "This function has %s lines, which is greater than the %s lines authorized. Split it into smaller functions.";
    private static final int DEFAULT = 200;
    @RuleProperty(key="max", description="Maximum authorized lines in a function", defaultValue="200")
    public int max = 200;
    private Set<FunctionTree> functionsDefiningModuleCurrentScript = new HashSet<FunctionTree>();

    public Set<Tree.Kind> nodesToVisit() {
        return ImmutableSet.builder().addAll((Iterable)KindSet.FUNCTION_KINDS.getSubKinds()).add((Object)Tree.Kind.SCRIPT).build();
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Kinds[]{Tree.Kind.SCRIPT})) {
            this.functionsDefiningModuleCurrentScript = FunctionDefiningModuleVisitor.getFunctionsDefiningModule((ScriptTree)((ScriptTree)tree));
        } else if (!this.functionsDefiningModuleCurrentScript.contains(tree)) {
            this.checkFunction((FunctionTree)tree);
        }
    }

    private void checkFunction(FunctionTree functionTree) {
        JavaScriptTree body = (JavaScriptTree)functionTree.body();
        int firstLine = body.firstToken().line();
        int lastLine = body.lastToken().endLine();
        int nbLines = lastLine - firstLine + 1;
        if (nbLines > this.max) {
            String message = String.format(MESSAGE, nbLines, this.max);
            IssueLocation primaryLocation = new IssueLocation((Tree)functionTree.firstToken(), functionTree.parameterClause(), message);
            this.addIssue((Issue)new PreciseIssue((JavaScriptCheck)this, primaryLocation));
        }
    }
}

