/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="S2611")
public class UntrustedContentCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Remove this content from an untrusted source.";
    @RuleProperty(key="domainsToIgnore", description="Comma-delimited list of domains to ignore. Regexes may be used, e.g. (.*\\.)?example\\.com,foo\\.org")
    public String domainsToIgnore = "";
    private List<Pattern> patterns = null;

    public Set<Tree.Kind> nodesToVisit() {
        return ImmutableSet.of((Object)Tree.Kind.STRING_LITERAL);
    }

    public void visitFile(Tree tree) {
        String[] pieces;
        this.patterns = new ArrayList<Pattern>();
        for (String piece : pieces = this.domainsToIgnore.split(",")) {
            this.patterns.add(Pattern.compile(piece));
        }
    }

    public void visitNode(Tree tree) {
        LiteralTree literal = (LiteralTree)tree;
        String value = literal.value();
        if ((value = value.substring(1, value.length() - 1)).matches("^http.*")) {
            try {
                URI uri = new URI(value);
                if (this.isBad(uri)) {
                    this.addIssue(tree, MESSAGE);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    private boolean isBad(URI uri) {
        for (Pattern pattern : this.patterns) {
            String host = uri.getHost();
            if (host != null && !pattern.matcher(host).matches()) continue;
            return false;
        }
        return true;
    }
}

