/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractAnyPathSeCheck;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.points.ProgramPoint;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;

@Rule(key="S3758")
public class ValuesNotConvertibleToNumbersCheck
extends AbstractAnyPathSeCheck {
    private static final String MESSAGE = "Re-evaluate the data flow; this operand of a numeric comparison could be %s.";
    private static final Constraint CONVERTIBLE_TO_NUMBER = Constraint.ANY_NUMBER.or(Constraint.ANY_BOOLEAN).or(Constraint.DATE).or(Constraint.NULL);

    public void beforeBlockElement(ProgramState currentState, Tree element, ProgramPoint programPoint) {
        if (element.is(new Kinds[]{Tree.Kind.LESS_THAN, Tree.Kind.LESS_THAN_OR_EQUAL_TO, Tree.Kind.GREATER_THAN, Tree.Kind.GREATER_THAN_OR_EQUAL_TO})) {
            this.check(currentState, (BinaryExpressionTree)element);
        }
    }

    private void check(ProgramState state, BinaryExpressionTree element) {
        Constraint leftConstraint = state.getConstraint(state.peekStack(1));
        Constraint rightConstraint = state.getConstraint(state.peekStack(0));
        boolean leftIsUndefined = leftConstraint.isStricterOrEqualTo(Constraint.UNDEFINED);
        boolean rightIsUndefined = rightConstraint.isStricterOrEqualTo(Constraint.UNDEFINED);
        boolean leftIsNan = leftConstraint.isStricterOrEqualTo(Constraint.NAN);
        boolean rightIsNan = rightConstraint.isStricterOrEqualTo(Constraint.NAN);
        if (ValuesNotConvertibleToNumbersCheck.checkObjectIsComparedNumerically(leftConstraint, rightConstraint)) {
            this.raiseIssue(element, true, false, "an Object");
        } else if (ValuesNotConvertibleToNumbersCheck.checkObjectIsComparedNumerically(rightConstraint, leftConstraint)) {
            this.raiseIssue(element, false, true, "an Object");
        } else if (leftIsUndefined || rightIsUndefined) {
            this.raiseIssue(element, leftIsUndefined, rightIsUndefined, "\"undefined\"");
        } else if (leftIsNan || rightIsNan) {
            this.raiseIssue(element, leftIsNan, rightIsNan, "NaN");
        }
    }

    private static boolean checkObjectIsComparedNumerically(Constraint constraint1, Constraint constraint2) {
        return ValuesNotConvertibleToNumbersCheck.isObjectNotConvertibleToNumber(constraint1) && ValuesNotConvertibleToNumbersCheck.isConvertibleToNumber(constraint2);
    }

    private static boolean isObjectNotConvertibleToNumber(Constraint c) {
        return c.isStricterOrEqualTo(Constraint.OBJECT) && !c.isStricterOrEqualTo(Constraint.BOOLEAN_OBJECT) && !c.isStricterOrEqualTo(Constraint.NUMBER_OBJECT) && !c.isStricterOrEqualTo(Constraint.DATE);
    }

    private static boolean isConvertibleToNumber(Constraint c) {
        return c.isStricterOrEqualTo(CONVERTIBLE_TO_NUMBER);
    }

    private void raiseIssue(BinaryExpressionTree comparison, boolean raiseIssueForLeft, boolean raiseIssueForRight, String messageParam) {
        if (raiseIssueForLeft) {
            this.raiseIssue(comparison.leftOperand(), messageParam);
        }
        if (raiseIssueForRight) {
            this.raiseIssue(comparison.rightOperand(), messageParam);
        }
    }

    private void raiseIssue(ExpressionTree operand, String messageParam) {
        this.addUniqueIssue((Tree)operand, String.format(MESSAGE, messageParam));
    }
}

