/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractSymbolNameCheck;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;

@Rule(key="BoundOrAssignedEvalOrArguments")
public class BoundOrAssignedEvalOrArgumentsCheck
extends AbstractSymbolNameCheck {
    private static final String DECLARATION_MESSAGE = "Do not use \"%s\" to declare a %s - use another name.";
    private static final String MODIFICATION_MESSAGE = "Remove the modification of \"%s\".";

    @Override
    List<String> illegalNames() {
        return ImmutableList.of((Object)"eval", (Object)"arguments");
    }

    public void visitScript(ScriptTree tree) {
        for (Symbol symbol : this.getIllegalSymbols()) {
            if (symbol.is(Symbol.Kind.PARAMETER) || !symbol.external()) {
                this.raiseIssuesOnDeclarations(symbol, String.format(DECLARATION_MESSAGE, symbol.name(), symbol.kind().getValue()));
                continue;
            }
            this.raiseIssuesOnWriteUsages(symbol);
        }
    }

    private void raiseIssuesOnWriteUsages(Symbol symbol) {
        for (Usage usage : symbol.usages()) {
            if (usage.kind().equals((Object)Usage.Kind.READ)) continue;
            this.addIssue((Tree)usage.identifierTree(), String.format(MODIFICATION_MESSAGE, symbol.name()));
        }
    }
}

