/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractSymbolNameCheck;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.tree.ScriptTree;

@Rule(key="FutureReservedWords")
public class FutureReservedWordsCheck
extends AbstractSymbolNameCheck {
    private static final String MESSAGE = "Rename \"%s\" identifier to prevent potential conflicts with future evolutions of the JavaScript language.";
    private static final List<String> FUTURE_RESERVED_WORDS = ImmutableList.of((Object)"implements", (Object)"interface", (Object)"package", (Object)"private", (Object)"protected", (Object)"public", (Object)"enum", (Object)"class", (Object)"const", (Object)"export", (Object)"extends", (Object)"import", (Object[])new String[]{"super", "let", "static", "yield", "await"});

    @Override
    List<String> illegalNames() {
        return FUTURE_RESERVED_WORDS;
    }

    public void visitScript(ScriptTree tree) {
        for (Symbol symbol : this.getIllegalSymbols()) {
            this.raiseIssuesOnDeclarations(symbol, String.format(MESSAGE, symbol.name()));
        }
    }
}

