/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.ModuleTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.CaseClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.DefaultClauseTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@Rule(key="S3972")
public class SameLineConditionalCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Move this \"if\" to a new line or add the missing \"else\".";

    public void visitModule(ModuleTree tree) {
        this.visitStatements(tree.items());
        super.visitModule(tree);
    }

    public void visitBlock(BlockTree tree) {
        this.visitStatements(tree.statements());
        super.visitBlock(tree);
    }

    public void visitDefaultClause(DefaultClauseTree tree) {
        this.visitStatements(tree.statements());
        super.visitDefaultClause(tree);
    }

    public void visitCaseClause(CaseClauseTree tree) {
        this.visitStatements(tree.statements());
        super.visitCaseClause(tree);
    }

    private <T extends Tree> void visitStatements(List<T> statementTrees) {
        if (statementTrees.size() < 2) {
            return;
        }
        for (int i = 1; i < statementTrees.size(); ++i) {
            Tree currentStatement = (Tree)statementTrees.get(i);
            Tree previousStatement = (Tree)statementTrees.get(i - 1);
            if (!currentStatement.is(new Kinds[]{Tree.Kind.IF_STATEMENT}) || !previousStatement.is(new Kinds[]{Tree.Kind.IF_STATEMENT})) continue;
            int previousStatementLastLine = previousStatement.lastToken().endLine();
            int previousStatementFirstLine = previousStatement.firstToken().line();
            int currentStatementFirstLine = currentStatement.firstToken().line();
            int currentStatementLastLine = currentStatement.lastToken().endLine();
            if (previousStatementLastLine != currentStatementFirstLine || previousStatementFirstLine == currentStatementLastLine) continue;
            this.addIssue((Tree)currentStatement.firstToken(), MESSAGE);
        }
    }
}

