/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;

@Rule(key="S3786")
public class TemplateStringMisuseCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Replace the quotes (%s) with back-ticks (`).";

    public Set<Tree.Kind> nodesToVisit() {
        return ImmutableSet.of((Object)Tree.Kind.STRING_LITERAL);
    }

    public void visitNode(Tree tree) {
        LiteralTree stringLiteral = (LiteralTree)tree;
        String value = stringLiteral.value();
        int startIndex = value.indexOf("${");
        int endIndex = value.indexOf(125);
        if (startIndex != -1 && startIndex < endIndex) {
            this.addIssue(tree, String.format(MESSAGE, Character.valueOf(value.charAt(0))));
        }
    }
}

