/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.sonar.javascript.se.SeCheck;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;

public abstract class AbstractAnyPathSeCheck
extends SeCheck {
    private Set<Tree> treesWithIssue = new HashSet<Tree>();

    public final void startOfExecution(Scope functionScope) {
        this.treesWithIssue.clear();
        this.doStartOfExecution(functionScope);
    }

    public void doStartOfExecution(Scope functionScope) {
    }

    public final PreciseIssue addIssue(Tree tree, String message) {
        throw new UnsupportedOperationException("Use one of 'addUniqueIssue' methods");
    }

    public final <T extends Issue> T addIssue(T issue) {
        throw new UnsupportedOperationException("Use one of 'addUniqueIssue' methods");
    }

    public Optional<PreciseIssue> addUniqueIssue(Tree tree, String message) {
        if (this.alreadyHasIssueOn(tree)) {
            return Optional.empty();
        }
        PreciseIssue issue = super.addIssue(tree, message);
        this.treesWithIssue.add(tree);
        return Optional.of(issue);
    }

    public Optional<PreciseIssue> addUniqueIssue(Tree tree, String message, Tree ... secondaryLocations) {
        Optional<PreciseIssue> issue = this.addUniqueIssue(tree, message);
        if (issue.isPresent()) {
            for (Tree location : secondaryLocations) {
                issue.get().secondary(location);
            }
        }
        return issue;
    }

    public Optional<PreciseIssue> addUniqueIssue(Tree tree, String message, IssueLocation ... secondaryLocations) {
        Optional<PreciseIssue> issue = this.addUniqueIssue(tree, message);
        if (issue.isPresent()) {
            for (IssueLocation location : secondaryLocations) {
                issue.get().secondary(location);
            }
        }
        return issue;
    }

    public boolean alreadyHasIssueOn(Tree tree) {
        return this.treesWithIssue.contains(tree);
    }
}

