/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.annotations.JavaScriptRule;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.SymbolModel;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@JavaScriptRule
@Rule(key="S2424")
public class BuiltInObjectOverriddenCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove this override of \"%s\".";
    private static final Set<Usage.Kind> ILLEGAL_USAGE_KINDS = EnumSet.of(Usage.Kind.DECLARATION, Usage.Kind.DECLARATION_WRITE, Usage.Kind.LEXICAL_DECLARATION, Usage.Kind.WRITE, Usage.Kind.READ_WRITE);
    private static final List<String> BUILD_IN_OBJECTS = ImmutableList.of((Object)"Object", (Object)"Function", (Object)"Boolean", (Object)"Symbol", (Object)"Error", (Object)"EvalError", (Object)"InternalError", (Object)"RangeError", (Object)"ReferenceError", (Object)"SyntaxError", (Object)"TypeError", (Object)"URIError", (Object[])new String[]{"Number", "Math", "Date", "String", "RegExp", "Array", "Int8Array", "Uint8Array", "Uint8ClampedArray", "Int16Array", "Unit16Array", "Int32Array", "Uint32Array", "Float32Array", "Float64Array", "Map", "Set", "WeakMap", "WeakSet", "ArrayBuffer", "DataView", "JSON", "Promise", "Reflect", "Proxy", "Intl", "Generator", "Iterator", "ParallelArray", "StopIteration"});

    public void visitScript(ScriptTree tree) {
        SymbolModel symbolModel = this.getContext().getSymbolModel();
        for (String name : BUILD_IN_OBJECTS) {
            for (Symbol symbol : symbolModel.getSymbols(name)) {
                this.checkSymbol(symbol);
            }
        }
    }

    private void checkSymbol(Symbol symbol) {
        for (Usage usage : symbol.usages()) {
            if (!ILLEGAL_USAGE_KINDS.contains(usage.kind())) continue;
            this.addIssue((Tree)usage.identifierTree(), String.format(MESSAGE, symbol.name()));
            return;
        }
    }
}

