/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.annotations.JavaScriptRule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@JavaScriptRule
@Rule(key="S3001")
public class DeleteNonPropertyCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove this \"delete\" operator or pass an object property to it.";

    public void visitUnaryExpression(UnaryExpressionTree tree) {
        ExpressionTree argument = CheckUtils.removeParenthesis(tree.expression());
        if (tree.is(new Kinds[]{Tree.Kind.DELETE}) && !DeleteNonPropertyCheck.isMemberAccess(argument) && !DeleteNonPropertyCheck.isGlobalProperty(argument)) {
            this.addIssue((Tree)tree, MESSAGE);
        }
        super.visitUnaryExpression(tree);
    }

    private static boolean isGlobalProperty(ExpressionTree expression) {
        Optional symbol;
        if (expression.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE}) && (symbol = ((IdentifierTree)expression).symbol()).isPresent()) {
            for (Usage usage : ((Symbol)symbol.get()).usages()) {
                if (!usage.isDeclaration()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isMemberAccess(ExpressionTree tree) {
        return tree.is(new Kinds[]{Tree.Kind.DOT_MEMBER_EXPRESSION, Tree.Kind.BRACKET_MEMBER_EXPRESSION});
    }
}

