/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.annotations.JavaScriptRule;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ArgumentListTree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;

@JavaScriptRule
@Rule(key="S3523")
public class FunctionConstructorCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Review this \"Function\" call and make sure its arguments are properly validated.";

    public void visitNewExpression(NewExpressionTree tree) {
        if (FunctionConstructorCheck.isFunctionConstructorWithPossibleInjection(tree.expression(), tree.argumentClause())) {
            this.addIssue((Issue)new PreciseIssue((JavaScriptCheck)this, new IssueLocation((Tree)tree.newKeyword(), (Tree)tree.expression(), MESSAGE)));
        }
        super.visitNewExpression(tree);
    }

    public void visitCallExpression(CallExpressionTree tree) {
        if (FunctionConstructorCheck.isFunctionConstructorWithPossibleInjection(tree.callee(), tree.argumentClause())) {
            this.addIssue((Tree)tree.callee(), MESSAGE);
        }
        super.visitCallExpression(tree);
    }

    private static boolean isFunctionConstructorWithPossibleInjection(ExpressionTree tree, @Nullable ArgumentListTree arguments) {
        boolean result = false;
        if (tree.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
            String name = ((IdentifierTree)tree).name();
            result = "Function".equals(name) && arguments != null && FunctionConstructorCheck.atLeastOneArgumentNotLiteral(arguments);
        }
        return result;
    }

    private static boolean atLeastOneArgumentNotLiteral(ArgumentListTree arguments) {
        for (ExpressionTree expressionTree : arguments.arguments()) {
            if (expressionTree.is(new Kinds[]{Tree.Kind.STRING_LITERAL})) continue;
            return true;
        }
        return false;
    }
}

