/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractAnyPathSeCheck;
import org.sonar.javascript.checks.annotations.JavaScriptRule;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.points.ProgramPoint;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;

@JavaScriptRule
@Rule(key="S3785")
public class InOperatorTypeErrorCheck
extends AbstractAnyPathSeCheck {
    private static final String MESSAGE = "TypeError can be thrown as this operand might have primitive type.";

    public void beforeBlockElement(ProgramState currentState, Tree element, ProgramPoint programPoint) {
        SymbolicValue rightOperandValue;
        Constraint rightOperandConstraint;
        if (element.is(new Kinds[]{Tree.Kind.RELATIONAL_IN}) && (rightOperandConstraint = currentState.getConstraint(rightOperandValue = currentState.peekStack())).isIncompatibleWith(Constraint.OBJECT)) {
            BinaryExpressionTree inOperation = (BinaryExpressionTree)element;
            this.addUniqueIssue((Tree)inOperation.rightOperand(), MESSAGE, new IssueLocation((Tree)inOperation.operatorToken()));
        }
    }
}

