/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.javascript.checks.annotations.JavaScriptRule;
import org.sonar.javascript.tree.symbols.type.Backbone;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.PairPropertyTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@JavaScriptRule
@Rule(key="S2550")
public class ModelDefaultsWithArrayOrObjectCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Make \"defaults\" a function.";

    public void visitCallExpression(CallExpressionTree tree) {
        PairPropertyTree defaultsProp;
        Tree parameter;
        if (tree.types().contains(Type.Kind.BACKBONE_MODEL) && !tree.argumentClause().arguments().isEmpty() && (parameter = (Tree)tree.argumentClause().arguments().get(0)).is(new Kinds[]{Tree.Kind.OBJECT_LITERAL}) && (defaultsProp = Backbone.getModelProperty((ObjectLiteralTree)((ObjectLiteralTree)parameter), (String)"defaults")) != null && defaultsProp.value().is(new Kinds[]{Tree.Kind.OBJECT_LITERAL}) && ModelDefaultsWithArrayOrObjectCheck.hasObjectOrArrayAttribute((ObjectLiteralTree)defaultsProp.value())) {
            this.addIssue(defaultsProp.key(), MESSAGE);
        }
        super.visitCallExpression(tree);
    }

    private static boolean hasObjectOrArrayAttribute(ObjectLiteralTree objectLiteral) {
        for (Tree property : objectLiteral.properties()) {
            if (!property.is(new Kinds[]{Tree.Kind.PAIR_PROPERTY}) || !((PairPropertyTree)property).value().is(new Kinds[]{Tree.Kind.ARRAY_LITERAL, Tree.Kind.OBJECT_LITERAL})) continue;
            return true;
        }
        return false;
    }
}

