/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.annotations.JavaScriptRule;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.ImportDeclarationTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;

@JavaScriptRule
@Rule(key="S3863")
public class SameModuleImportsCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Merge this import with another one from the same module on line %s.";
    private ListMultimap<String, ImportDeclarationTree> simpleImportsByModule;
    private ListMultimap<String, ImportDeclarationTree> typeOfImportsByModule;
    private ListMultimap<String, ImportDeclarationTree> typeImportsByModule;

    public void visitScript(ScriptTree tree) {
        this.simpleImportsByModule = ArrayListMultimap.create();
        this.typeOfImportsByModule = ArrayListMultimap.create();
        this.typeImportsByModule = ArrayListMultimap.create();
        super.visitScript(tree);
        this.checkImports(this.simpleImportsByModule);
        this.checkImports(this.typeOfImportsByModule);
        this.checkImports(this.typeImportsByModule);
    }

    private void checkImports(ListMultimap<String, ImportDeclarationTree> importsByModule) {
        for (String moduleName : importsByModule.keySet()) {
            List imports = importsByModule.get((Object)moduleName);
            if (imports.size() <= 1) continue;
            ImportDeclarationTree lastImport = (ImportDeclarationTree)imports.get(imports.size() - 1);
            ImportDeclarationTree firstImport = (ImportDeclarationTree)imports.get(0);
            PreciseIssue preciseIssue = this.addIssue((Tree)lastImport, String.format(MESSAGE, firstImport.firstToken().line()));
            for (int i = 0; i < imports.size() - 1; ++i) {
                preciseIssue.secondary((Tree)imports.get(i));
            }
        }
    }

    public void visitImportDeclaration(ImportDeclarationTree tree) {
        SyntaxToken flowTypeToken = tree.flowImportTypeOrTypeOfToken();
        if (flowTypeToken == null) {
            SameModuleImportsCheck.addImportModule(tree, this.simpleImportsByModule);
        } else if (flowTypeToken.text().equals("type")) {
            SameModuleImportsCheck.addImportModule(tree, this.typeImportsByModule);
        } else {
            SameModuleImportsCheck.addImportModule(tree, this.typeOfImportsByModule);
        }
    }

    private static void addImportModule(ImportDeclarationTree tree, ListMultimap<String, ImportDeclarationTree> importsByModule) {
        String literal = tree.fromClause().module().value();
        String moduleName = literal.substring(1, literal.length() - 1);
        importsByModule.put((Object)moduleName, (Object)tree);
    }
}

