/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.javascript.checks.EslintBasedCheck;
import org.sonar.javascript.checks.annotations.JavaScriptRule;
import org.sonar.javascript.checks.annotations.TypeScriptRule;

@JavaScriptRule
@TypeScriptRule
@Rule(key="S104")
public class TooManyLinesInFileCheck
extends EslintBasedCheck {
    private static final int DEFAULT = 1000;
    @RuleProperty(key="maximum", description="Maximum authorized lines in a file.", defaultValue="1000")
    public int maximum = 1000;

    @Override
    public List<Object> configurations() {
        return Collections.singletonList(new Config(this.maximum));
    }

    @Override
    public String eslintKey() {
        return "max-lines";
    }

    private static class Config {
        int max;
        boolean skipBlankLines = true;
        boolean skipComments = true;

        Config(int max) {
            this.max = max;
        }
    }
}

