/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.javascript.checks.annotations.JavaScriptRule;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.InitializedBindingElementTree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@JavaScriptRule
@Rule(key="S2138")
public class UndefinedAssignmentCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Use null instead.";

    public void visitInitializedBindingElement(InitializedBindingElementTree tree) {
        if (UndefinedAssignmentCheck.isUndefined(tree.right())) {
            this.addIssue((Tree)tree.right(), MESSAGE);
        }
        super.visitInitializedBindingElement(tree);
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        if (tree.is(new Kinds[]{Tree.Kind.ASSIGNMENT}) && UndefinedAssignmentCheck.isUndefined(tree.expression())) {
            this.addIssue((Tree)tree.expression(), MESSAGE);
        }
        super.visitAssignmentExpression(tree);
    }

    private static boolean isUndefined(ExpressionTree expression) {
        return expression.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE}) && "undefined".equals(((IdentifierTree)expression).name());
    }
}

