/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.cfg.CfgBlock;
import org.sonar.javascript.cfg.ControlFlowGraph;
import org.sonar.javascript.checks.annotations.JavaScriptRule;
import org.sonar.javascript.tree.KindSet;
import org.sonar.javascript.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.SeparatedList;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.BindingElementTree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.VariableDeclarationTree;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@JavaScriptRule
@Rule(key="S1736")
@DeprecatedRuleKey(ruleKey="UnreachableCode")
public class UnreachableCodeCheck
extends SubscriptionVisitorCheck {
    private static final String MESSAGE = "Remove this code after the \"%s\" statement.";
    private static final String MESSAGE_WITHOUT_KEYWORD = "Remove this unreachable code.";

    public Set<Tree.Kind> nodesToVisit() {
        return ImmutableSet.builder().addAll((Iterable)KindSet.FUNCTION_KINDS.getSubKinds()).add((Object)Tree.Kind.SCRIPT).build();
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Kinds[]{Tree.Kind.SCRIPT})) {
            this.check(ControlFlowGraph.build((ScriptTree)((ScriptTree)tree)));
        } else {
            FunctionTree functionTree = (FunctionTree)tree;
            if (functionTree.body().is(new Kinds[]{Tree.Kind.BLOCK})) {
                this.check(ControlFlowGraph.build((BlockTree)((BlockTree)functionTree.body())));
            }
        }
    }

    private void check(ControlFlowGraph cfg) {
        for (CfgBlock unreachable : cfg.unreachableBlocks()) {
            Tree element = UnreachableCodeCheck.unreachableTree(unreachable.elements());
            if (element == null || UnreachableCodeCheck.isLastBreakInSwitchCase(element) || UnreachableCodeCheck.isDeclarationWithoutInit(element)) continue;
            Set disconnectingJumps = cfg.disconnectingJumps(unreachable);
            String message = MESSAGE_WITHOUT_KEYWORD;
            if (disconnectingJumps.size() == 1) {
                SyntaxToken keyword = (SyntaxToken)disconnectingJumps.iterator().next();
                message = String.format(MESSAGE, keyword.text());
            }
            PreciseIssue issue = this.addIssue(element, message);
            for (SyntaxToken jump : disconnectingJumps) {
                issue.secondary((Tree)jump);
            }
        }
    }

    private static boolean isDeclarationWithoutInit(Tree tree) {
        if (tree.is(new Kinds[]{Tree.Kind.VAR_DECLARATION})) {
            SeparatedList bindingElements = ((VariableDeclarationTree)tree).variables();
            for (BindingElementTree bindingElement : bindingElements) {
                if (!bindingElement.is(new Kinds[]{Tree.Kind.INITIALIZED_BINDING_ELEMENT})) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isLastBreakInSwitchCase(Tree tree) {
        if (tree.is(new Kinds[]{Tree.Kind.BREAK_STATEMENT})) {
            Tree parent = tree.parent();
            if (parent.is(new Kinds[]{Tree.Kind.CASE_CLAUSE, Tree.Kind.DEFAULT_CLAUSE})) {
                SwitchClauseTree switchClause = (SwitchClauseTree)parent;
                return ((StatementTree)switchClause.statements().get(switchClause.statements().size() - 1)).equals(tree);
            }
        }
        return false;
    }

    private static Tree unreachableTree(List<Tree> elements) {
        List<Tree> unreachableElements = UnreachableCodeCheck.skipDeclarations(elements);
        if (unreachableElements.isEmpty()) {
            return null;
        }
        Tree biggestUnreachableElement = unreachableElements.get(0);
        for (Tree element : unreachableElements) {
            if (UnreachableCodeCheck.startIndex(element) > UnreachableCodeCheck.startIndex(biggestUnreachableElement) || UnreachableCodeCheck.endIndex(element) < UnreachableCodeCheck.endIndex(biggestUnreachableElement)) continue;
            biggestUnreachableElement = element;
        }
        return biggestUnreachableElement;
    }

    private static List<Tree> skipDeclarations(List<Tree> elements) {
        int i = 0;
        for (Tree element : elements) {
            if (!element.is(new Kinds[]{Tree.Kind.FUNCTION_DECLARATION, Tree.Kind.GENERATOR_DECLARATION, Tree.Kind.CLASS_DECLARATION})) {
                return elements.subList(i, elements.size());
            }
            ++i;
        }
        return ImmutableList.of();
    }

    private static int startIndex(Tree element) {
        InternalSyntaxToken firstToken = (InternalSyntaxToken)element.firstToken();
        return firstToken.startIndex();
    }

    private static int endIndex(Tree element) {
        InternalSyntaxToken lastToken = (InternalSyntaxToken)element.lastToken();
        return lastToken.toIndex();
    }
}

