/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.ArrayList;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.annotations.JavaScriptRule;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;

@JavaScriptRule
@Rule(key="S3500")
public class UpdatedConstVariableCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Correct this attempt to modify \"%s\" or use \"let\" in its declaration.";

    public void visitScript(ScriptTree tree) {
        for (Symbol constSymbol : this.getContext().getSymbolModel().getSymbols(Symbol.Kind.CONST_VARIABLE)) {
            Usage declaration = null;
            ArrayList<Usage> writeUsages = new ArrayList<Usage>();
            for (Usage usage : constSymbol.usages()) {
                if (declaration == null && usage.isDeclaration() && usage.isWrite()) {
                    declaration = usage;
                    continue;
                }
                if (!usage.isWrite()) continue;
                writeUsages.add(usage);
            }
            if (declaration == null) continue;
            for (Usage writeUsage : writeUsages) {
                PreciseIssue preciseIssue = this.addIssue((Tree)writeUsage.identifierTree(), String.format(MESSAGE, constSymbol.name()));
                preciseIssue.secondary((Tree)declaration.identifierTree(), "Const declaration");
            }
        }
    }
}

