/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.javascript.checks.annotations.JavaScriptRule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.BracketMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@JavaScriptRule
@Rule(key="S3579")
public class AssociativeArraysCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Make \"%s\" an object if it must have named properties; otherwise, use a numeric index here.";

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        ExpressionTree arrayIndex;
        BracketMemberExpressionTree memberExpression;
        if (tree.variable().is(new Kinds[]{Tree.Kind.BRACKET_MEMBER_EXPRESSION}) && (memberExpression = (BracketMemberExpressionTree)tree.variable()).object().types().containsOnly(Type.Kind.ARRAY) && (arrayIndex = memberExpression.property()).types().containsOnly(Type.Kind.STRING)) {
            this.addIssue((Tree)arrayIndex, String.format(MESSAGE, CheckUtils.asString((Tree)memberExpression.object())));
        }
        super.visitAssignmentExpression(tree);
    }
}

