/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.javascript.checks.annotations.JavaScriptRule;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BracketMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@JavaScriptRule
@Rule(key="S2870")
public class DeleteArrayElementCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Remove this use of \"delete\".";

    public void visitUnaryExpression(UnaryExpressionTree tree) {
        if (tree.is(new Kinds[]{Tree.Kind.DELETE}) && DeleteArrayElementCheck.isArrayElement(tree.expression())) {
            this.addIssue((Tree)tree.operatorToken(), MESSAGE);
        }
        super.visitUnaryExpression(tree);
    }

    private static boolean isArrayElement(ExpressionTree expression) {
        return expression.is(new Kinds[]{Tree.Kind.BRACKET_MEMBER_EXPRESSION}) && ((BracketMemberExpressionTree)expression).object().types().containsOnly(Type.Kind.ARRAY);
    }
}

