/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.annotations.JavaScriptRule;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.SeCheck;
import org.sonar.javascript.se.points.ProgramPoint;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.BinaryExpressionTree;

@JavaScriptRule
@Rule(key="S3403")
public class DifferentTypesComparisonCheck
extends SeCheck {
    private static final String MESSAGE_EQUAL = "Remove this \"===\" check; it will always be false. Did you mean to use \"==\"?";
    private static final String MESSAGE_NOT_EQUAL = "Remove this \"!==\" check; it will always be true. Did you mean to use \"!=\"?";
    private Map<BinaryExpressionTree, Boolean> typeDifference = new HashMap<BinaryExpressionTree, Boolean>();

    public void beforeBlockElement(ProgramState currentState, Tree element, ProgramPoint programPoint) {
        if (element.is(new Kinds[]{Tree.Kind.STRICT_NOT_EQUAL_TO, Tree.Kind.STRICT_EQUAL_TO})) {
            boolean differentTypes;
            BinaryExpressionTree comparison = (BinaryExpressionTree)element;
            Constraint rightConstraint = currentState.getConstraint(currentState.peekStack(0));
            Constraint leftConstraint = currentState.getConstraint(currentState.peekStack(1));
            Set rightType = rightConstraint.typeSet();
            Set leftType = leftConstraint.typeSet();
            boolean bl = differentTypes = !rightType.isEmpty() && !leftType.isEmpty() && Sets.intersection((Set)rightType, (Set)leftType).isEmpty();
            if (!differentTypes) {
                this.typeDifference.put(comparison, false);
            } else if (!this.typeDifference.containsKey(comparison)) {
                this.typeDifference.put(comparison, true);
            }
        }
    }

    public void endOfExecution(Scope functionScope) {
        for (Map.Entry<BinaryExpressionTree, Boolean> entry : this.typeDifference.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            this.raiseIssue(entry.getKey());
        }
    }

    public void startOfExecution(Scope functionScope) {
        this.typeDifference.clear();
    }

    private void raiseIssue(BinaryExpressionTree tree) {
        String message = tree.is(new Kinds[]{Tree.Kind.STRICT_EQUAL_TO}) ? MESSAGE_EQUAL : MESSAGE_NOT_EQUAL;
        this.addIssue((Tree)tree.operatorToken(), message).secondary((Tree)tree.leftOperand()).secondary((Tree)tree.rightOperand());
    }
}

