/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.EscapeUtils;
import org.sonar.javascript.checks.annotations.JavaScriptRule;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.AccessorMethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.ClassTree;
import org.sonar.plugins.javascript.api.tree.declaration.FieldDeclarationTree;
import org.sonar.plugins.javascript.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.PairPropertyTree;
import org.sonar.plugins.javascript.api.tree.flow.FlowMethodPropertyDefinitionKeyTree;
import org.sonar.plugins.javascript.api.tree.flow.FlowObjectTypeTree;
import org.sonar.plugins.javascript.api.tree.flow.FlowPropertyDefinitionTree;
import org.sonar.plugins.javascript.api.tree.flow.FlowSimplePropertyDefinitionKeyTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@JavaScriptRule
@Rule(key="S1534")
@DeprecatedRuleKey(ruleKey="DuplicatePropertyName")
public class DuplicatePropertyNameCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Rename or remove duplicate property name '%s'.";

    public void visitObjectLiteral(ObjectLiteralTree tree) {
        this.checkProperties((List)tree.properties());
        super.visitObjectLiteral(tree);
    }

    public void visitClass(ClassTree tree) {
        this.checkProperties(tree.elements());
        super.visitClass(tree);
    }

    public void visitFlowObjectTypeTree(FlowObjectTypeTree tree) {
        this.checkProperties((List)tree.properties());
        super.visitFlowObjectTypeTree(tree);
    }

    private <T extends Tree> void checkProperties(List<T> properties) {
        LinkedListMultimap keys = LinkedListMultimap.create();
        LinkedListMultimap staticKeys = LinkedListMultimap.create();
        for (Tree property : properties) {
            String propertyName;
            Tree propertyNameTree = DuplicatePropertyNameCheck.getPropertyNameTree(property);
            if (propertyNameTree == null || (propertyName = DuplicatePropertyNameCheck.getPropertyName(propertyNameTree)) == null) continue;
            if (DuplicatePropertyNameCheck.isStatic(property)) {
                staticKeys.put((Object)EscapeUtils.unescape(propertyName), (Object)property);
                continue;
            }
            keys.put((Object)EscapeUtils.unescape(propertyName), (Object)property);
        }
        this.checkKeys((ListMultimap<String, Tree>)keys);
        this.checkKeys((ListMultimap<String, Tree>)staticKeys);
    }

    private static boolean isStatic(Tree property) {
        if (property.is(new Kinds[]{Tree.Kind.METHOD, Tree.Kind.GENERATOR_METHOD})) {
            return ((MethodDeclarationTree)property).staticToken() != null;
        }
        if (property.is(new Kinds[]{Tree.Kind.GET_METHOD, Tree.Kind.SET_METHOD})) {
            return ((AccessorMethodDeclarationTree)property).staticToken() != null;
        }
        if (property.is(new Kinds[]{Tree.Kind.FIELD})) {
            return ((FieldDeclarationTree)property).staticToken() != null;
        }
        if (property.is(new Kinds[]{Tree.Kind.FLOW_PROPERTY_DEFINITION})) {
            return ((FlowPropertyDefinitionTree)property).staticToken() != null;
        }
        return false;
    }

    private void checkKeys(ListMultimap<String, Tree> keys) {
        for (String key : keys.keySet()) {
            List properties = keys.get((Object)key);
            if (properties.size() <= 1 || DuplicatePropertyNameCheck.getterSetter(properties)) continue;
            Tree duplicatedProperty = DuplicatePropertyNameCheck.getPropertyNameTree((Tree)properties.remove(0));
            for (Tree property : properties) {
                Tree propertyKey = DuplicatePropertyNameCheck.getPropertyNameTree(property);
                this.addIssue(propertyKey, String.format(MESSAGE, DuplicatePropertyNameCheck.getPropertyName(propertyKey))).secondary(duplicatedProperty);
            }
        }
    }

    private static boolean getterSetter(List<Tree> value) {
        if (value.size() == 2) {
            return value.get(0).is(new Kinds[]{Tree.Kind.GET_METHOD}) && value.get(1).is(new Kinds[]{Tree.Kind.SET_METHOD}) || value.get(1).is(new Kinds[]{Tree.Kind.GET_METHOD}) && value.get(0).is(new Kinds[]{Tree.Kind.SET_METHOD});
        }
        return false;
    }

    @Nullable
    private static Tree getPropertyNameTree(Tree property) {
        if (property.is(new Kinds[]{Tree.Kind.METHOD, Tree.Kind.GENERATOR_METHOD})) {
            return ((MethodDeclarationTree)property).name();
        }
        if (property.is(new Kinds[]{Tree.Kind.GET_METHOD, Tree.Kind.SET_METHOD})) {
            return ((AccessorMethodDeclarationTree)property).name();
        }
        if (property.is(new Kinds[]{Tree.Kind.FIELD})) {
            return ((FieldDeclarationTree)property).propertyName();
        }
        if (property.is(new Kinds[]{Tree.Kind.PAIR_PROPERTY})) {
            return ((PairPropertyTree)property).key();
        }
        if (property.is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE})) {
            return property;
        }
        if (property.is(new Kinds[]{Tree.Kind.FLOW_PROPERTY_DEFINITION})) {
            return ((FlowPropertyDefinitionTree)property).key();
        }
        return null;
    }

    @Nullable
    private static String getPropertyName(Tree propertyKey) {
        FlowMethodPropertyDefinitionKeyTree methodKey;
        if (propertyKey.is(new Kinds[]{Tree.Kind.STRING_LITERAL})) {
            return DuplicatePropertyNameCheck.trimLiteralQuotes(((LiteralTree)propertyKey).value());
        }
        if (propertyKey.is(new Kinds[]{Tree.Kind.PROPERTY_IDENTIFIER, Tree.Kind.IDENTIFIER_REFERENCE})) {
            return ((IdentifierTree)propertyKey).name();
        }
        if (propertyKey.is(new Kinds[]{Tree.Kind.NUMERIC_LITERAL})) {
            return ((LiteralTree)propertyKey).value();
        }
        if (propertyKey.is(new Kinds[]{Tree.Kind.FLOW_SIMPLE_PROPERTY_DEFINITION_KEY})) {
            SyntaxToken nameToken = ((FlowSimplePropertyDefinitionKeyTree)propertyKey).nameToken();
            if (nameToken.is(new Kinds[]{Tree.Kind.STRING_LITERAL})) {
                return DuplicatePropertyNameCheck.trimLiteralQuotes(((LiteralTree)nameToken).value());
            }
            return nameToken.text();
        }
        if (propertyKey.is(new Kinds[]{Tree.Kind.FLOW_METHOD_PROPERTY_DEFINITION_KEY}) && (methodKey = (FlowMethodPropertyDefinitionKeyTree)propertyKey).methodName() != null) {
            return methodKey.methodName().name();
        }
        return null;
    }

    private static String trimLiteralQuotes(String value) {
        return value.substring(1, value.length() - 1);
    }
}

