/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.javascript.checks.annotations.JavaScriptRule;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForObjectStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.StatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@JavaScriptRule
@Rule(key="S1535")
@DeprecatedRuleKey(ruleKey="ForIn")
public class ForInCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Restrict what this loop acts on by testing each property.";

    public void visitForObjectStatement(ForObjectStatementTree tree) {
        if (tree.is(new Kinds[]{Tree.Kind.FOR_IN_STATEMENT})) {
            StatementTree statementNode = tree.statement();
            if (statementNode.is(new Kinds[]{Tree.Kind.BLOCK})) {
                BlockTree block = (BlockTree)statementNode;
                StatementTree statementTree = statementNode = !block.statements().isEmpty() ? (StatementTree)block.statements().get(0) : null;
            }
            if (statementNode != null && !statementNode.is(new Kinds[]{Tree.Kind.IF_STATEMENT}) && !ForInCheck.isAttrCopy(statementNode)) {
                this.addIssue((Tree)tree.forKeyword(), MESSAGE);
            }
        }
        super.visitForObjectStatement(tree);
    }

    private static boolean isAttrCopy(StatementTree statement) {
        if (statement.is(new Kinds[]{Tree.Kind.EXPRESSION_STATEMENT})) {
            ExpressionTree expression = ((ExpressionStatementTree)statement).expression();
            if (expression.is(new Kinds[]{Tree.Kind.ASSIGNMENT})) {
                AssignmentExpressionTree assignment = (AssignmentExpressionTree)expression;
                return assignment.variable().is(new Kinds[]{Tree.Kind.BRACKET_MEMBER_EXPRESSION});
            }
        }
        return false;
    }
}

