/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.javascript.cfg.CfgBlock;
import org.sonar.javascript.cfg.CfgBranchingBlock;
import org.sonar.javascript.cfg.ControlFlowGraph;
import org.sonar.javascript.checks.annotations.JavaScriptRule;
import org.sonar.javascript.checks.utils.CheckUtils;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.SeCheck;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.symbols.Usage;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.statement.ConditionalTree;
import org.sonar.plugins.javascript.api.tree.statement.DoWhileStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.ForStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.IterationStatementTree;
import org.sonar.plugins.javascript.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitor;

@JavaScriptRule
@Rule(key="S2189")
public class LoopsShouldNotBeInfiniteCheck
extends SeCheck {
    private FileLoops fileLoops;
    private Set<Tree> alwaysTrueConditions = new HashSet<Tree>();

    protected void startOfFile(ScriptTree scriptTree) {
        this.alwaysTrueConditions.clear();
        this.fileLoops = FileLoops.create(scriptTree);
    }

    public void checkConditions(Map<Tree, Collection<Constraint>> conditions) {
        this.alwaysTrueConditions.addAll(conditions.entrySet().stream().filter(treeCollectionEntry -> LoopsShouldNotBeInfiniteCheck.alwaysTrue((Collection)treeCollectionEntry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet()));
    }

    public void endOfFile(ScriptTree scriptTree) {
        this.fileLoops.loopsAndConditions.entrySet().stream().filter(entry -> this.isInfiniteLoop((IterationStatementTree)entry.getKey(), (JavaScriptTree)entry.getValue())).forEach(entry -> this.addIssue((IterationStatementTree)entry.getKey()));
    }

    private void addIssue(IterationStatementTree loop) {
        loop.accept((DoubleDispatchVisitor)new LoopIssueCreator());
    }

    private static boolean alwaysTrue(Collection<Constraint> results) {
        if (results.size() == 1) {
            Constraint constraint = results.iterator().next();
            return Constraint.TRUTHY.equals((Object)constraint);
        }
        return false;
    }

    private boolean isInfiniteLoop(IterationStatementTree tree, @Nullable JavaScriptTree condition) {
        if (LoopsShouldNotBeInfiniteCheck.isNeverExecutedLoop(condition)) {
            return false;
        }
        ControlFlowGraph flowGraph = CheckUtils.buildControlFlowGraph((Tree)tree);
        Map<Tree, CfgBlock> treesOfFlowGraph = LoopsShouldNotBeInfiniteCheck.treesToBlocks(flowGraph);
        if (LoopsShouldNotBeInfiniteCheck.isBrokenLoop(condition, tree, flowGraph)) {
            return false;
        }
        return condition == null || !LoopsShouldNotBeInfiniteCheck.conditionIsUpdated(condition, (JavaScriptTree)tree, treesOfFlowGraph) || this.alwaysTrueConditions.contains(condition);
    }

    private static boolean isBrokenLoop(@Nullable JavaScriptTree condition, IterationStatementTree loopTree, ControlFlowGraph flowGraph) {
        Loop loop = new Loop(flowGraph, loopTree, condition);
        return !loop.jumpingExits().isEmpty();
    }

    private static boolean conditionIsUpdated(JavaScriptTree condition, JavaScriptTree loopTree, Map<Tree, CfgBlock> treesOfFlowGraph) {
        Set<Symbol> conditionSymbols = LoopsShouldNotBeInfiniteCheck.allSymbols(condition).collect(Collectors.toSet());
        Stream<Symbol> writtenSymbols = LoopsShouldNotBeInfiniteCheck.allSymbolsUsages(loopTree).filter(LoopsShouldNotBeInfiniteCheck::isWriteUsage).map(Usage::symbol);
        Set<Symbol> symbolsTouchedOutsideFlowGraph = LoopsShouldNotBeInfiniteCheck.symbolsTouchedOutsideFlowGraph(conditionSymbols, treesOfFlowGraph);
        boolean anySymbolTouchedInAnotherFunction = !symbolsTouchedOutsideFlowGraph.isEmpty();
        return writtenSymbols.anyMatch(conditionSymbols::contains) || anySymbolTouchedInAnotherFunction;
    }

    private static boolean isNeverExecutedLoop(@Nullable JavaScriptTree condition) {
        if (condition instanceof LiteralTree) {
            LiteralTree literal = (LiteralTree)condition;
            if ("false".equals(literal.value())) {
                return true;
            }
            if ("0".equals(literal.value())) {
                return true;
            }
        }
        return false;
    }

    private static Set<Symbol> symbolsTouchedOutsideFlowGraph(Set<Symbol> conditionSymbols, Map<Tree, CfgBlock> treesOfFlowGraph) {
        return conditionSymbols.stream().flatMap(symbol -> symbol.usages().stream()).filter(usage -> !treesOfFlowGraph.containsKey(usage.identifierTree())).filter(LoopsShouldNotBeInfiniteCheck::isWriteUsage).map(Usage::symbol).collect(Collectors.toSet());
    }

    private static boolean isWriteUsage(Usage usage) {
        if (usage.isWrite()) {
            return true;
        }
        return usage.identifierTree().parent().is(new Kinds[]{Tree.Kind.DOT_MEMBER_EXPRESSION, Tree.Kind.BRACKET_MEMBER_EXPRESSION, Tree.Kind.CALL_EXPRESSION});
    }

    private static Map<Tree, CfgBlock> treesToBlocks(ControlFlowGraph graph) {
        HashMap<Tree, CfgBlock> treesToFlowBlock = new HashMap<Tree, CfgBlock>();
        graph.blocks().forEach(cfgBlock -> cfgBlock.elements().forEach(element -> treesToFlowBlock.put((Tree)element, (CfgBlock)cfgBlock)));
        return treesToFlowBlock;
    }

    private static Stream<Symbol> allSymbols(JavaScriptTree root) {
        Stream<JavaScriptTree> thisAndDescendants = Stream.concat(Stream.builder().add(root).build(), root.descendants());
        return thisAndDescendants.filter(tree -> tree instanceof IdentifierTree).map(tree -> (IdentifierTree)tree).map(IdentifierTree::symbol).filter(Optional::isPresent).map(Optional::get);
    }

    private static Stream<Usage> allSymbolsUsages(JavaScriptTree root) {
        return LoopsShouldNotBeInfiniteCheck.allSymbols(root).flatMap(symbol -> symbol.usages().stream()).filter(usage -> root.isAncestorOf((Tree)usage.identifierTree()));
    }

    private class LoopIssueCreator
    extends DoubleDispatchVisitor {
        private LoopIssueCreator() {
        }

        public void visitWhileStatement(WhileStatementTree tree) {
            this.createIssue((Tree)tree.whileKeyword(), tree.condition());
        }

        public void visitDoWhileStatement(DoWhileStatementTree tree) {
            this.createIssue((Tree)tree.doKeyword(), tree.condition());
        }

        public void visitForStatement(ForStatementTree tree) {
            if (tree.condition() == null) {
                LoopsShouldNotBeInfiniteCheck.this.addIssue((Tree)tree.forKeyword(), "Add an end condition for this loop.").secondary(new IssueLocation((Tree)tree.firstSemicolonToken(), (Tree)tree.secondSemicolonToken(), null));
            } else {
                this.createIssue((Tree)tree.forKeyword(), tree.condition());
            }
        }

        private void createIssue(Tree keyword, ExpressionTree condition) {
            LoopsShouldNotBeInfiniteCheck.this.addIssue(keyword, "Correct this loop's end condition as to not be invariant.").secondary(new IssueLocation((Tree)condition, null));
        }
    }

    private static class Loop {
        private final Set<CfgBranchingBlock> branchBlocks;
        private final Set<CfgBlock> loopBlocks;

        Loop(ControlFlowGraph flowGraph, IterationStatementTree iteration, @Nullable JavaScriptTree condition) {
            this.branchBlocks = Loop.findRootBranchingBlocks(flowGraph, iteration, condition);
            Map treesOfFlowGraph = LoopsShouldNotBeInfiniteCheck.treesToBlocks(flowGraph);
            Set<CfgBlock> foundLoopBlocks = Loop.findLoopBlocks(iteration, treesOfFlowGraph);
            this.branchBlocks.forEach(foundLoopBlocks::add);
            this.loopBlocks = foundLoopBlocks;
        }

        private static Set<CfgBranchingBlock> findRootBranchingBlocks(ControlFlowGraph flowGraph, IterationStatementTree iteration, @Nullable JavaScriptTree condition) {
            return flowGraph.blocks().stream().filter(cfgBlock -> cfgBlock instanceof CfgBranchingBlock).map(cfgBlock -> (CfgBranchingBlock)cfgBlock).filter(cfgBranchingBlock -> Loop.blockBelongsToLoopEndCondition(cfgBranchingBlock, iteration, condition)).collect(Collectors.toSet());
        }

        private static boolean blockBelongsToLoopEndCondition(CfgBranchingBlock cfgBranchingBlock, IterationStatementTree iteration, @Nullable JavaScriptTree condition) {
            Tree branchingTree = cfgBranchingBlock.branchingTree();
            if (iteration.equals(branchingTree)) {
                return true;
            }
            if (condition != null) {
                return condition.equals(branchingTree) || condition.isAncestorOf(branchingTree);
            }
            return false;
        }

        private static Set<CfgBlock> findLoopBlocks(IterationStatementTree iterationStatement, Map<Tree, CfgBlock> treesOfFlowGraph) {
            Stream<JavaScriptTree> iterationTrees = iterationStatement.statement().descendants();
            iterationTrees = Loop.addUpdateExpression(iterationStatement, iterationTrees);
            return iterationTrees.map(treesOfFlowGraph::get).filter(Objects::nonNull).collect(Collectors.toSet());
        }

        private static Stream<JavaScriptTree> addUpdateExpression(IterationStatementTree iterationStatement, Stream<JavaScriptTree> iterationTrees) {
            if (iterationStatement instanceof ForStatementTree) {
                return Stream.concat(iterationTrees, Stream.of((JavaScriptTree)((ForStatementTree)iterationStatement).update()));
            }
            return iterationTrees;
        }

        Set<CfgBlock> jumpingExits() {
            Set<CfgBlock> exits = this.exits();
            this.branchBlocks.forEach(exits::remove);
            return exits;
        }

        final Set<CfgBlock> exits() {
            return this.loopBlocks.stream().filter(this::isExit).collect(Collectors.toSet());
        }

        private boolean isExit(CfgBlock cfgBlock) {
            return cfgBlock.successors().stream().anyMatch(successor -> !this.loopBlocks.contains(successor));
        }
    }

    private static class FileLoops
    extends SubscriptionVisitor {
        private Map<IterationStatementTree, ExpressionTree> loopsAndConditions = new HashMap<IterationStatementTree, ExpressionTree>();

        private FileLoops() {
        }

        static FileLoops create(ScriptTree scriptTree) {
            FileLoops fileLoops = new FileLoops();
            fileLoops.scanTree((Tree)scriptTree);
            return fileLoops;
        }

        public Set<Tree.Kind> nodesToVisit() {
            return ImmutableSet.of((Object)Tree.Kind.FOR_STATEMENT, (Object)Tree.Kind.WHILE_STATEMENT, (Object)Tree.Kind.DO_WHILE_STATEMENT);
        }

        public void visitNode(Tree tree) {
            this.loopsAndConditions.put((IterationStatementTree)tree, ((ConditionalTree)tree).condition());
        }
    }
}

