/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.annotations.JavaScriptRule;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.SeparatedList;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ArrayLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectLiteralTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@JavaScriptRule
@Rule(key="S3723")
public class MissingTrailingCommaCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Add a trailing comma to this item of the list.";

    public void visitObjectLiteral(ObjectLiteralTree tree) {
        if (MissingTrailingCommaCheck.isMultiline(tree) && !MissingTrailingCommaCheck.endsWithComma(tree)) {
            this.raiseIssueOnLastElement((List<? extends Tree>)tree.properties());
        }
        super.visitObjectLiteral(tree);
    }

    public void visitArrayLiteral(ArrayLiteralTree tree) {
        if (MissingTrailingCommaCheck.isMultiline(tree) && !MissingTrailingCommaCheck.endsWithComma(tree)) {
            this.raiseIssueOnLastElement(tree.elements());
        }
        super.visitArrayLiteral(tree);
    }

    private static boolean isMultiline(ObjectLiteralTree objectLiteral) {
        return MissingTrailingCommaCheck.isMultilineInternal((List<? extends Tree>)objectLiteral.properties(), objectLiteral.closeCurlyBraceToken());
    }

    private static boolean isMultiline(ArrayLiteralTree arrayLiteral) {
        return MissingTrailingCommaCheck.isMultilineInternal(arrayLiteral.elements(), arrayLiteral.closeBracketToken());
    }

    private static boolean isMultilineInternal(List<? extends Tree> list, SyntaxToken closingToken) {
        if (!list.isEmpty()) {
            Tree last = list.get(list.size() - 1);
            return last.lastToken().endLine() != closingToken.line();
        }
        return false;
    }

    private static boolean endsWithComma(ObjectLiteralTree objectLiteral) {
        SeparatedList properties = objectLiteral.properties();
        return properties.size() == properties.getSeparators().size();
    }

    private static boolean endsWithComma(ArrayLiteralTree arrayLiteral) {
        Tree last = (Tree)arrayLiteral.elementsAndCommas().get(arrayLiteral.elementsAndCommas().size() - 1);
        return last.is(new Kinds[]{Tree.Kind.TOKEN});
    }

    private void raiseIssueOnLastElement(List<? extends Tree> list) {
        this.addIssue(list.get(list.size() - 1), MESSAGE);
    }
}

