/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractAnyPathSeCheck;
import org.sonar.javascript.checks.annotations.JavaScriptRule;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.Type;
import org.sonar.javascript.se.points.MemberProgramPoint;
import org.sonar.javascript.se.points.ProgramPoint;
import org.sonar.javascript.se.sv.SpecialSymbolicValue;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;

@JavaScriptRule
@Rule(key="S3759")
public class NonExistentPropertyAccessCheck
extends AbstractAnyPathSeCheck {
    private static final String MESSAGE = "Remove this access to \"%s\" property, it doesn't exist, as a built-in, on %s.";
    private static final Map<Type, String> TYPE_NAMES = ImmutableMap.builder().put((Object)Type.NUMBER_PRIMITIVE, (Object)"Number").put((Object)Type.NUMBER_OBJECT, (Object)"Number").put((Object)Type.STRING_PRIMITIVE, (Object)"String").put((Object)Type.STRING_OBJECT, (Object)"String").put((Object)Type.BOOLEAN_PRIMITIVE, (Object)"Boolean").put((Object)Type.BOOLEAN_OBJECT, (Object)"Boolean").build();

    public void beforeBlockElement(ProgramState currentState, Tree element, ProgramPoint programPoint) {
        if (NonExistentPropertyAccessCheck.isUndefinedProperty(currentState, element, programPoint)) {
            IdentifierTree propertyTree = ((DotMemberExpressionTree)element).property();
            this.addUniqueIssue(element, String.format(MESSAGE, propertyTree.name(), NonExistentPropertyAccessCheck.getTypeOfObject(currentState)));
        }
    }

    private static String getTypeOfObject(ProgramState programState) {
        Constraint constraintOnObject = programState.getConstraint(programState.peekStack());
        Type type = Type.find((Constraint)constraintOnObject);
        return TYPE_NAMES.containsKey(type) ? "a " + TYPE_NAMES.get(type) : "this object";
    }

    private static boolean isUndefinedProperty(ProgramState currentState, Tree element, ProgramPoint programPoint) {
        if (element.is(new Kinds[]{Tree.Kind.DOT_MEMBER_EXPRESSION})) {
            Optional programState = ((MemberProgramPoint)programPoint).executeStrictMode(currentState);
            return programState.isPresent() && SpecialSymbolicValue.UNDEFINED.equals((Object)((ProgramState)programState.get()).peekStack());
        }
        return false;
    }
}

