/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.annotations.JavaScriptRule;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.SeparatedList;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.CallExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;

@JavaScriptRule
@Rule(key="S3533")
public class NonStandardImportCheck
extends DoubleDispatchVisitorCheck {
    private static final String MESSAGE = "Use a standard \"import\" statement instead of \"%s(...)\".";
    private static final Set<String> AMD_IMPORT_FUNCTIONS = ImmutableSet.of((Object)"require", (Object)"define");
    private static final String COMMON_JS_IMPORT_FUNCTION = "require";

    public void visitCallExpression(CallExpressionTree tree) {
        SeparatedList parameters;
        String name;
        IdentifierTree callee;
        if (tree.callee().is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE}) && (callee = (IdentifierTree)tree.callee()).scope().isGlobal() && (NonStandardImportCheck.isAmdImport(name = callee.name(), (SeparatedList<ExpressionTree>)(parameters = tree.argumentClause().arguments())) || NonStandardImportCheck.isCommonJsImport(name, (SeparatedList<ExpressionTree>)parameters))) {
            this.addIssue((Tree)tree.callee(), String.format(MESSAGE, name));
        }
    }

    private static boolean isAmdImport(String callee, SeparatedList<ExpressionTree> parameters) {
        if (AMD_IMPORT_FUNCTIONS.contains(callee)) {
            if (parameters.size() == 3) {
                return NonStandardImportCheck.firstIsStringLiteral(parameters) && NonStandardImportCheck.lastIsFunction(parameters);
            }
            if (parameters.size() == 2) {
                return NonStandardImportCheck.lastIsFunction(parameters);
            }
        }
        return false;
    }

    private static boolean lastIsFunction(SeparatedList<ExpressionTree> parameters) {
        return ((ExpressionTree)parameters.get(parameters.size() - 1)).types().contains(Type.Kind.FUNCTION);
    }

    private static boolean isCommonJsImport(String callee, SeparatedList<ExpressionTree> parameters) {
        return COMMON_JS_IMPORT_FUNCTION.equals(callee) && parameters.size() == 1 && NonStandardImportCheck.firstIsStringLiteral(parameters);
    }

    private static boolean firstIsStringLiteral(SeparatedList<ExpressionTree> parameters) {
        return ((ExpressionTree)parameters.get(0)).is(new Kinds[]{Tree.Kind.STRING_LITERAL});
    }
}

