/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import org.sonar.check.Rule;
import org.sonar.javascript.checks.AbstractAllPathSeCheck;
import org.sonar.javascript.checks.annotations.JavaScriptRule;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.se.sv.UnknownSymbolicValue;
import org.sonar.javascript.tree.SyntacticEquivalence;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;

@JavaScriptRule
@Rule(key="S4165")
public class RedundantAssignmentCheck
extends AbstractAllPathSeCheck<AssignmentExpressionTree> {
    private static final String MESSAGE = "Review this useless assignment: \"%s\" already holds the assigned value along all execution paths.";

    @Override
    AssignmentExpressionTree getTree(Tree element) {
        if (element.is(new Kinds[]{Tree.Kind.ASSIGNMENT})) {
            return (AssignmentExpressionTree)element;
        }
        return null;
    }

    @Override
    boolean isProblem(AssignmentExpressionTree tree, ProgramState currentState) {
        SymbolicValue rightSide = currentState.peekStack(0);
        SymbolicValue leftSide = currentState.peekStack(1);
        if (!tree.variable().is(new Kinds[]{Tree.Kind.IDENTIFIER_REFERENCE}) || SyntacticEquivalence.areEquivalent((Tree)tree.variable(), (Tree)tree.expression())) {
            return false;
        }
        if (leftSide instanceof UnknownSymbolicValue || rightSide instanceof UnknownSymbolicValue) {
            return false;
        }
        if (leftSide == rightSide) {
            return true;
        }
        Constraint leftConstraint = currentState.getConstraint(leftSide);
        Constraint rightConstraint = currentState.getConstraint(rightSide);
        return leftConstraint.isSingleValue() && rightConstraint.isSingleValue() && leftConstraint.equals((Object)rightConstraint);
    }

    @Override
    void raiseIssue(AssignmentExpressionTree tree) {
        IdentifierTree variable = (IdentifierTree)tree.variable();
        this.addIssue((Tree)tree, String.format(MESSAGE, variable.name()));
    }
}

