/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks;

import com.google.common.collect.Iterables;
import org.sonar.check.Rule;
import org.sonar.javascript.checks.annotations.JavaScriptRule;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.statement.DefaultClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchClauseTree;
import org.sonar.plugins.javascript.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitorCheck;
import org.sonarsource.analyzer.commons.annotations.DeprecatedRuleKey;

@JavaScriptRule
@Rule(key="S131")
@DeprecatedRuleKey(ruleKey="SwitchWithoutDefault")
public class SwitchWithoutDefaultCheck
extends DoubleDispatchVisitorCheck {
    private static final String ADD_DEFAULT_MESSAGE = "Add a \"default\" clause to this \"switch\" statement.";
    private static final String MOVE_DEFAULT_MESSAGE = "Move this \"default\" clause to the end of this \"switch\" statement.";

    public void visitSwitchStatement(SwitchStatementTree tree) {
        DefaultClauseTree defaultClause = SwitchWithoutDefaultCheck.getDefaultClause(tree);
        if (defaultClause == null) {
            this.addIssue((Tree)tree.switchKeyword(), ADD_DEFAULT_MESSAGE);
        } else if (!((SwitchClauseTree)Iterables.getLast((Iterable)tree.cases())).is(new Kinds[]{Tree.Kind.DEFAULT_CLAUSE})) {
            this.addIssue((Tree)defaultClause.keyword(), MOVE_DEFAULT_MESSAGE);
        }
        super.visitSwitchStatement(tree);
    }

    private static DefaultClauseTree getDefaultClause(SwitchStatementTree switchStmt) {
        for (SwitchClauseTree clause : switchStmt.cases()) {
            if (!clause.is(new Kinds[]{Tree.Kind.DEFAULT_CLAUSE})) continue;
            return (DefaultClauseTree)clause;
        }
        return null;
    }
}

