/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.checks.utils;

import java.util.HashSet;
import java.util.Set;
import org.sonar.javascript.cfg.CfgBlock;
import org.sonar.javascript.cfg.CfgBranchingBlock;
import org.sonar.javascript.cfg.ControlFlowGraph;
import org.sonar.plugins.javascript.api.tree.Kinds;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.tree.statement.ReturnStatementTree;

public class FunctionReturns {
    private boolean containsReturnWithValue = false;
    private boolean containsReturnWithoutValue = false;
    private boolean containsImplicitReturn = false;
    private Set<ReturnStatementTree> returnStatements = new HashSet<ReturnStatementTree>();

    public static FunctionReturns getFunctionReturns(BlockTree functionBody) {
        FunctionReturns functionReturns = new FunctionReturns();
        ControlFlowGraph cfg = ControlFlowGraph.build((BlockTree)functionBody);
        if (FunctionReturns.containsTry(cfg)) {
            return functionReturns;
        }
        CfgBlock endBlock = cfg.end();
        for (CfgBlock cfgBlock : endBlock.predecessors()) {
            Tree lastElement = (Tree)cfgBlock.elements().get(cfgBlock.elements().size() - 1);
            if (lastElement.is(new Kinds[]{Tree.Kind.RETURN_STATEMENT})) {
                ReturnStatementTree returnStatement = (ReturnStatementTree)lastElement;
                if (returnStatement.expression() == null) {
                    functionReturns.containsReturnWithoutValue = true;
                } else {
                    functionReturns.containsReturnWithValue = true;
                }
                functionReturns.returnStatements.add(returnStatement);
                continue;
            }
            if (FunctionReturns.isThrowStatement(lastElement) || !FunctionReturns.isReachableBlock(cfgBlock, cfg)) continue;
            functionReturns.containsReturnWithoutValue = true;
            functionReturns.containsImplicitReturn = true;
        }
        return functionReturns;
    }

    private static boolean containsTry(ControlFlowGraph cfg) {
        for (CfgBlock cfgBlock : cfg.blocks()) {
            if (!(cfgBlock instanceof CfgBranchingBlock) || !((CfgBranchingBlock)cfgBlock).branchingTree().is(new Kinds[]{Tree.Kind.TRY_STATEMENT})) continue;
            return true;
        }
        return false;
    }

    private static boolean isThrowStatement(Tree lastElement) {
        return lastElement.parent().is(new Kinds[]{Tree.Kind.THROW_STATEMENT});
    }

    private static boolean isReachableBlock(CfgBlock cfgBlock, ControlFlowGraph cfg) {
        return !cfgBlock.predecessors().isEmpty() || cfgBlock.equals(cfg.start());
    }

    public boolean containsReturnWithValue() {
        return this.containsReturnWithValue;
    }

    public boolean containsReturnWithoutValue() {
        return this.containsReturnWithoutValue;
    }

    public boolean containsImplicitReturn() {
        return this.containsImplicitReturn;
    }

    public Set<ReturnStatementTree> returnStatements() {
        return this.returnStatements;
    }
}

